/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sentrysoftware.ipmi.client.runner.AbstractIpmiRunner;

public class Utils {
    public static final String EMPTY = "";

    private Utils() {
    }

    public static boolean isBlank(String value) {
        return value == null || Utils.isEmpty(value);
    }

    public static boolean isNotBlank(String value) {
        return !Utils.isBlank(value);
    }

    public static boolean isEmpty(String value) {
        return value.trim().isEmpty();
    }

    public static String getValueOrEmpty(String value) {
        return Utils.isBlank(value) ? EMPTY : value;
    }

    public static <T> T execute(AbstractIpmiRunner<T> callable, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<T> future = executorService.submit(callable);
        try {
            T t = future.get(timeout, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

