/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client.model;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.ReadingType;

public class ReadingTypeDescription {
    private static final String PREDICTIVE_FAILURE = "Predictive failure";
    private static final Map<ReadingType, String> READING_TYPE_TO_DESCRIPTION;

    private ReadingTypeDescription() {
    }

    public static String getReadingType(ReadingType readingType) {
        return READING_TYPE_TO_DESCRIPTION.get((Object)readingType);
    }

    static {
        EnumMap<ReadingType, String> map = new EnumMap<ReadingType, String>(ReadingType.class);
        map.put(ReadingType.FruInactive, "Inactive");
        map.put(ReadingType.SlotConnectorIdentifyStatusAsserted, "Identify Status");
        map.put(ReadingType.HardReset, "Hard reset");
        map.put(ReadingType.FruLatchOpen, "FRU Latch");
        map.put(ReadingType.FruActivationRequested, "Activation Requested");
        map.put(ReadingType.SlotConnectorDeviceInstalled, "Device Installed");
        map.put(ReadingType.WarmReset, "Warm Reset");
        map.put(ReadingType.FruActivationInProgress, "Activation in Progress");
        map.put(ReadingType.SlotConnectorReadyForDeviceInstallation, "Ready for Device Installation");
        map.put(ReadingType.PxeBootRequested, "User requested PXE boot");
        map.put(ReadingType.FruActive, "Active");
        map.put(ReadingType.InvalidUsernameOrPassword, "Invalid Username Or Password");
        map.put(ReadingType.SlotConnectorReadyForDeviceRemoval, "Ready for Device Removal");
        map.put(ReadingType.AutomaticBootToDiagnostic, "Automatic boot to diagnostic");
        map.put(ReadingType.FruDeactivationRequested, "Deactivation Requested");
        map.put(ReadingType.InvalidPasswordDisable, "Invalid Password Disable");
        map.put(ReadingType.EntityPresent, "Device Present");
        map.put(ReadingType.SlotPowerOff, "Slot Power is Off");
        map.put(ReadingType.SoftwareInitiatedHardReset, "OS initiated hard reset");
        map.put(ReadingType.FruDeactivationInProgress, "Deactivation in Progress");
        map.put(ReadingType.SensorFailure, "Sensor failure");
        map.put(ReadingType.EntityAbsent, "Device Absent");
        map.put(ReadingType.SoftwareInitiatedWarmReset, "OS initiated warm reset");
        map.put(ReadingType.FruCommunicationLost, "Communication lost");
        map.put(ReadingType.FruFailure, "FRU failure");
        map.put(ReadingType.SystemRestart, "System Restart");
        map.put(ReadingType.StateDeasserted, "0");
        map.put(ReadingType.SystemFirmwareError, "Firmware Error");
        map.put(ReadingType.StateAsserted, "1");
        map.put(ReadingType.SystemFirmwareHang, "Firmware Hang");
        map.put(ReadingType.SystemFirmwareProgress, "Firmware Progress");
        map.put(ReadingType.HardwareChangeDetected, "Hardware change detected");
        map.put(ReadingType.Frb1BistFailure, "FRB1/BIST failure");
        map.put(ReadingType.FirmwareOrSoftwareChangeDetected, "Firmware or software change detected");
        map.put(ReadingType.Frb2HangInPostFailure, "FRB2/Hang in POST failure");
        map.put(ReadingType.HardwareIncompatibilityDetected, "Hardware incompatibility detected");
        map.put(ReadingType.Frb3ProcessorStartupFailure, "FRB3/Processor startup/init failure");
        map.put(ReadingType.FirmwareOrSoftwareIncompatibilityDetected, "Firmware or software incompatibility detected");
        map.put(ReadingType.DrivePresence, "Drive Present");
        map.put(ReadingType.ConfigurationError, "Configuration Error");
        map.put(ReadingType.InvalidOrUnsupportedHardware, "Invalid or unsupported hardware version");
        map.put(ReadingType.DriveFault, "Drive Fault");
        map.put(ReadingType.UncorrectableCpuComplexError, "SM BIOS Uncorrectable CPU-complex Error");
        map.put(ReadingType.InvalidOrUnsupportedFirmwareOrSoftware, "Invalid or unsupported firmware or software version");
        map.put(ReadingType.PredictiveFailure, PREDICTIVE_FAILURE);
        map.put(ReadingType.ProcessorPresenceDetected, "Presence detected");
        map.put(ReadingType.HotSpare, "Hot Spare");
        map.put(ReadingType.ProcessorDisabled, "Disabled");
        map.put(ReadingType.ConsistencyOrParityCheckInProgress, "Parity Check In Progress");
        map.put(ReadingType.TerminatorPresenceDetected, "Terminator presence detected");
        map.put(ReadingType.SecureModeViolationAttempt, "Secure Mode Violation Attempt");
        map.put(ReadingType.OsGracefulStop, "OS graceful stop");
        map.put(ReadingType.InCriticalArray, "In Critical Array");
        map.put(ReadingType.ProcessorAutomaticallyThrottled, "Throttled");
        map.put(ReadingType.PreBootUserPasswordViolation, "Pre-boot password violation - user password");
        map.put(ReadingType.OsGracefulShutdown, "OS graceful shutdown");
        map.put(ReadingType.MachineCheckException, "Machine Check Exception");
        map.put(ReadingType.PreBootSetupPasswordViolation, "Pre-boot password violation - setup password");
        map.put(ReadingType.SoftOsShutdown, "PEF initiated soft shutdown");
        map.put(ReadingType.PreBootNetworkPasswordViolation, "Pre-boot password violation - network boot password");
        map.put(ReadingType.LANHeartbeatLost, "Heartbeat Lost");
        map.put(ReadingType.AgentNotResponding, "Agent not responding");
        map.put(ReadingType.OtherPreBootPasswordViolation, "Other pre-boot password violation");
        map.put(ReadingType.LANHeartbeat, "Heartbeat");
        map.put(ReadingType.OutOfBandAccessPasswordViolation, "Out-of-band access password violation");
        map.put(ReadingType.DeviceAbsent, "Device Absent");
        map.put(ReadingType.Parity, "Parity");
        map.put(ReadingType.DevicePresent, "Device Present");
        map.put(ReadingType.MemoryScrubFailed, "Memory Scrub Failed");
        map.put(ReadingType.MemoryDeviceDisabled, "Memory Device Disabled");
        map.put(ReadingType.CorrectableEccOtherCorrectableMemoryErrorLoggingLimitReached, "Correctable ECC logging limit reached");
        map.put(ReadingType.MemoryPresenceDetected, "Presence Detected");
        map.put(ReadingType.MemoryConfigurationError, "Configuration Error");
        map.put(ReadingType.SpareMemoryUnit, "Spare");
        map.put(ReadingType.MemoryAutomaticallyThrottled, "Throttled");
        map.put(ReadingType.MemoryCriticalOvertemperature, "Critical Overtemperature");
        map.put(ReadingType.SystemReconfigured, "System Reconfigured");
        map.put(ReadingType.OemSystemBootEvent, "OEM System boot event");
        map.put(ReadingType.ABootCompleted, "A: boot completed");
        map.put(ReadingType.UndeterminedSystemHardwareFailure, "Undetermined system hardware failure");
        map.put(ReadingType.TransitionToRunning, "Transition to Running");
        map.put(ReadingType.CBootCompleted, "C: boot completed");
        map.put(ReadingType.EntryAddedToAuxiliaryLog, "Entry added to auxiliary log");
        map.put(ReadingType.TransitionToInTest, "Transition to In Test");
        map.put(ReadingType.PxeBootCompleted, "PXE boot completed");
        map.put(ReadingType.PefAction, "PEF Action");
        map.put(ReadingType.TransitionToPowerOff, "Transition to Power Off");
        map.put(ReadingType.DiagnosticBootCompleted, "Diagnostic boot completed");
        map.put(ReadingType.TimestampClockSynch, "Timestamp Clock Sync");
        map.put(ReadingType.TransitionToOnLine, "Transition to On Line");
        map.put(ReadingType.CdRomBootCompleted, "CD-ROM boot completed");
        map.put(ReadingType.BootSourceSelectionTimeout, "Timeout waiting for selection");
        map.put(ReadingType.PowerSupplyConfigurationError, "Config Error");
        map.put(ReadingType.TransitionToOffLine, "Transition to Off Line");
        map.put(ReadingType.TimerExpired, "Timer expired");
        map.put(ReadingType.RomBootCompleted, "ROM boot completed");
        map.put(ReadingType.TransitionToOffDuty, "Transition to Off Duty");
        map.put(ReadingType.TimerHardReset, "Hard reset");
        map.put(ReadingType.BootCompleted, "boot completed - device not specified");
        map.put(ReadingType.PredictiveFailureDeasserted, "Predictive Failure Deasserted");
        map.put(ReadingType.TransitionToDegraded, "Transition to Degraded");
        map.put(ReadingType.TimerPowerDown, "Power down");
        map.put(ReadingType.AcpiS5EnteredByOverride, "S5: entered by override");
        map.put(ReadingType.LANLeashLost, "Leash Lost");
        map.put(ReadingType.Predictive, "Predictive Failure Asserted");
        map.put(ReadingType.TransitionToPowerSave, "Transition to Power Save");
        map.put(ReadingType.TimerPowerCycle, "Power cycle");
        map.put(ReadingType.AcpiLegacyOnState, "Legacy ON state");
        map.put(ReadingType.PowerOffOrDown, "Power off/down");
        map.put(ReadingType.UnauthorizedDock, "Unauthorized dock");
        map.put(ReadingType.InstallError, "Install Error");
        map.put(ReadingType.AcpiLegacyOffState, "Legacy OFF state");
        map.put(ReadingType.PowerCycle, "Power cycle");
        map.put(ReadingType.FANAreaIntrusion, "FAN area intrusion");
        map.put(ReadingType.FullyRedundant, "Fully Redundant");
        map.put(ReadingType.CableInterconnectConnected, "Connected");
        map.put(ReadingType.PowerDown240V, "240VA power down");
        map.put(ReadingType.RedundancyLost, "Redundancy Lost");
        map.put(ReadingType.AcpiUnknown, "Unknown");
        map.put(ReadingType.CableInterconnectConfigurationError, "Config Error");
        map.put(ReadingType.InterlockPowerDown, "Interlock power down");
        map.put(ReadingType.RedundancyDegraded, "Redundancy Degraded");
        map.put(ReadingType.BatteryLow, "Low");
        map.put(ReadingType.PowerInputLost, "AC lost");
        map.put(ReadingType.NonRedundant_SufficientResourcesFromRedundant, "Non-Redundant: Sufficient from Redundant");
        map.put(ReadingType.BatteryFailed, "Failed");
        map.put(ReadingType.PowerUnitSoftPowerControlFailure, "Soft-power control failure");
        map.put(ReadingType.BatteryPresenceDetected, "Presence Detected");
        map.put(ReadingType.PowerUnitFailure, "Failure detected");
        map.put(ReadingType.PowerUnitPredictiveFailure, PREDICTIVE_FAILURE);
        map.put(ReadingType.BusFatalError, "Bus Fatal Error");
        map.put(ReadingType.CorrectableMemoryErrorLoggingDisabled, "Correctable memory error logging disabled");
        map.put(ReadingType.BusDegraded, "Bus Degraded");
        map.put(ReadingType.EventTypeLoggingDisabled, "Event logging disabled");
        map.put(ReadingType.LogAreaReset, "Log area reset/cleared");
        map.put(ReadingType.TransitionToOK, "Transition to OK");
        map.put(ReadingType.AllEventLoggingDisabled, "All event logging disabled");
        map.put(ReadingType.TransitionToNonCriticalFromOK, "Transition to Non-critical from OK");
        map.put(ReadingType.FruServiceRequestButtonPressed, "FRU Service");
        map.put(ReadingType.SelFull, "Log full");
        map.put(ReadingType.TransitionToCriticalFromLessSevere, "Transition to Critical from less severe");
        map.put(ReadingType.SelAlmostFull, "Log almost full");
        map.put(ReadingType.TransitionToNonRecoverableFromLessSevere, "Transition to Non-recoverable from less severe");
        map.put(ReadingType.CorrectableMachineCheckErrorLoggingDisabled, "Correctable Machine Check Error Logging Disabled");
        map.put(ReadingType.TransitionToNonCriticalFromMoreSevere, "Transition to Non-critical from more severe");
        map.put(ReadingType.TransitionToCriticalFromNonRecoverable, "Transition to Critical from Non-recoverable");
        map.put(ReadingType.SlotConnectorDeviceRemovalRequest, "Device Removal Request");
        map.put(ReadingType.TransitionToNonRecoverable, "Transition to Non-recoverable");
        map.put(ReadingType.EntityDisabled, "Device Disabled");
        map.put(ReadingType.InterlockAsserted, "Interlock");
        map.put(ReadingType.Monitor, "Monitor");
        map.put(ReadingType.SlotDisabled, "Slot is Disabled");
        map.put(ReadingType.SlotHoldsSpareDevice, "Spare Device");
        map.put(ReadingType.PlatformGeneratedPage, "Platform generated page");
        map.put(ReadingType.PlatformGeneratedLanAlert, "Platform generated LAN alert");
        map.put(ReadingType.PlatformEventTrapGenerated, "Platform Event Trap generated");
        map.put(ReadingType.PlatformGeneratedSnmpTrap, "Platform generated SNMP trap, OEM format");
        map.put(ReadingType.SensorAccessUnavailable, "Sensor access degraded or unavailable");
        map.put(ReadingType.ControllerAccessUnavailable, "Controller access degraded or unavailable");
        map.put(ReadingType.ManagementControllerOffLine, "Management controller off-line");
        map.put(ReadingType.SuccessfulHardwareChangeDetected, "Hardware change success");
        map.put(ReadingType.ManagementControllerUnavailable, "Management controller unavailable");
        map.put(ReadingType.SuccessfulSoftwareOrFWChangeDetected, "Firmware or software change success");
        map.put(ReadingType.InFailedArray, "In Failed Array");
        map.put(ReadingType.RebuildRemapInProgress, "Rebuild In Progress");
        map.put(ReadingType.CorrectableMachineCheckError, "Correctable Machine Check Error");
        map.put(ReadingType.RebuildRemapAborted, "Rebuild Aborted");
        map.put(ReadingType.Ierr, "IERR");
        map.put(ReadingType.ChipsetSoftPowerControlFailure, "Soft-power control failure");
        map.put(ReadingType.ProcessorThermalTrip, "Thermal Trip");
        map.put(ReadingType.ChipsetThermalTrip, "Thermal Trip");
        map.put(ReadingType.D0PowerState, "D0 Power State");
        map.put(ReadingType.D1PowerState, "D1 Power State");
        map.put(ReadingType.D2PowerState, "D2 Power State");
        map.put(ReadingType.D3PowerState, "D3 Power State");
        map.put(ReadingType.CriticalStopDuringOsLoad, "Error during system startup");
        map.put(ReadingType.RunTimeCriticalStop, "Run-time critical stop");
        map.put(ReadingType.DeviceDisabled, "Device Disabled");
        map.put(ReadingType.DeviceEnabled, "Device Enabled");
        map.put(ReadingType.CorrectableEcc, "Correctable ECC");
        map.put(ReadingType.UncorrectableECC, "Uncorrectable ECC");
        map.put(ReadingType.LimitNotExceeded, "Limit Not Exceeded");
        map.put(ReadingType.LimitExceeded, "Limit Exceeded");
        map.put(ReadingType.AcpiS0G0Working, "S0/G0: working");
        map.put(ReadingType.AcpiS1SleepingProcessorContextMaintained, "S1: sleeping with system hw & processor context maintained");
        map.put(ReadingType.PowerSupplyPresenceDetected, "Presence detected");
        map.put(ReadingType.AcpiS2SleepingProcessorContextLost, "S2: sleeping, processor context lost");
        map.put(ReadingType.PowerSupplyFailureDetected, "Failure detected");
        map.put(ReadingType.TimerInterrupt, "Timer interrupt");
        map.put(ReadingType.AcpiS3SleepingProcessorContextLostMemoryRetained, "S3: sleeping, processor & hw context lost, memory retained");
        map.put(ReadingType.PowerSupplyPredictiveFailure, PREDICTIVE_FAILURE);
        map.put(ReadingType.NonRedundant_SufficientResourcesFromInsufficientResources, "Non-Redundant: Sufficient from Insufficient");
        map.put(ReadingType.AcpiS4NonVolatileSleep, "S4: non-volatile sleep/suspend-to-disk");
        map.put(ReadingType.PowerSupplyInputLost, "Power Supply AC lost");
        map.put(ReadingType.NonRedundant_InsufficientResources, "Non-Redundant: Insufficient Resources");
        map.put(ReadingType.AcpiS5G2SoftOff, "S5/G2: soft-off");
        map.put(ReadingType.PowerSupplyInputLostOrOutOfRange, "AC lost or out-of-range");
        map.put(ReadingType.RedundancyDegradedFromFullyRedundant, "Redundancy Degraded from Fully Redundant");
        map.put(ReadingType.PerformanceMet, "Performance Met");
        map.put(ReadingType.AcpiS4S5SoftOffStateUndetermined, "S4/S5: soft-off");
        map.put(ReadingType.PowerSupplyInputOutOfRange, "AC out-of-range, but present");
        map.put(ReadingType.RedundancyDegradedFromNonRedundant, "Redundancy Degraded from Non-Redundant");
        map.put(ReadingType.PerformanceLags, "Performance Lags");
        map.put(ReadingType.AcpiG3MechanicalOff, "G3: mechanical off");
        map.put(ReadingType.AcpiSleepingInS1S2OrS3, "Sleeping in S1/S2/S3 state");
        map.put(ReadingType.AcpiG1Sleeping, "G1: sleeping");
        map.put(ReadingType.FrontPanelInterrupt, "NMI/Diag Interrupt");
        map.put(ReadingType.Informational, "Informational");
        map.put(ReadingType.NoBootableMedia, "No bootable media");
        map.put(ReadingType.BusTimeout, "Bus Timeout");
        map.put(ReadingType.NonBootableDisketteLeftInDrive, "Unrecoverable diskette failure");
        map.put(ReadingType.IoChannelCheckNmi, "I/O Channel check NMI");
        map.put(ReadingType.PxeServerNotFound, "PXE server not found");
        map.put(ReadingType.Software, ReadingType.Software.name());
        map.put(ReadingType.InvalidBootSector, "Invalid boot sector");
        map.put(ReadingType.PciPErr, "PCI PERR");
        map.put(ReadingType.GeneralChassisIntrusion, "General Chassis intrusion");
        map.put(ReadingType.TransitionToIdle, "Transition to Idle");
        map.put(ReadingType.PciSErr, "PCI SERR");
        map.put(ReadingType.DriveBayIntrusion, "Drive Bay intrusion");
        map.put(ReadingType.TransitionToActive, "Transition to Active");
        map.put(ReadingType.EisaFailSafeTimeout, "EISA failsafe timeout");
        map.put(ReadingType.IoCardAreaIntrusion, "I/O Card area intrusion");
        map.put(ReadingType.TransitionToBusy, "Transition to Busy");
        map.put(ReadingType.BusCorrectableError, "Bus Correctable error");
        map.put(ReadingType.ProcessorAreaIntrusion, "Processor area intrusion");
        map.put(ReadingType.BusUncorrectableError, "Bus Uncorrectable error");
        map.put(ReadingType.FatalNmi, "Fatal NMI");
        map.put(ReadingType.PowerButtonPressed, "Power Button pressed");
        map.put(ReadingType.SleepButtonPressed, "Sleep Button pressed");
        map.put(ReadingType.FruNotInstalled, "Not Installed");
        map.put(ReadingType.SlotConnectorFaultStatusAsserted, "Fault Status");
        map.put(ReadingType.PowerUp, "Power up");
        map.put(ReadingType.ResetButtonPressed, "Reset Button pressed");
        map.put(ReadingType.Unknown, ReadingType.Unknown.name());
        READING_TYPE_TO_DESCRIPTION = Collections.unmodifiableMap(map);
    }
}

