/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.client.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.ipmi.client.model.ReadingTypeDescription;
import org.sentrysoftware.ipmi.client.model.Sensor;
import org.sentrysoftware.ipmi.client.runner.AbstractIpmiRunner;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSensorReading;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSensorReadingResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.ReserveSdrRepository;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.ReserveSdrRepositoryResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.CompactSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.FullSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.ReadingType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetSensorsRunner
extends AbstractIpmiRunner<List<Sensor>> {
    private static final int OEM_EVENT_READING_TYPE = 127;

    public GetSensorsRunner(IpmiClientConfiguration ipmiConfiguration) {
        super(ipmiConfiguration);
    }

    @Override
    public List<Sensor> call() throws Exception {
        ArrayList<Sensor> result = new ArrayList<Sensor>();
        super.startSession();
        this.nextRecId = 0;
        int reservationId = 0;
        int lastReservationId = -1;
        while (this.nextRecId < 65535) {
            SensorRecord sensorRecord = null;
            try {
                sensorRecord = super.getSensorData(reservationId);
                if (!(sensorRecord instanceof FullSensorRecord) && !(sensorRecord instanceof CompactSensorRecord)) continue;
                int recordReadingId = this.getReadingId(sensorRecord);
                GetSensorReadingResponseData data = this.getSensorRecordReading(recordReadingId);
                String states = GetSensorsRunner.buildStates(data, sensorRecord);
                result.add(new Sensor(sensorRecord, data, states));
            }
            catch (IPMIException e) {
                if (lastReservationId == reservationId || e.getCompletionCode() != CompletionCode.ReservationCanceled) {
                    throw e;
                }
                lastReservationId = reservationId;
                reservationId = ((ReserveSdrRepositoryResponseData)this.connector.sendMessage(this.handle, new ReserveSdrRepository(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus))).getReservationId();
            }
        }
        return result;
    }

    static String buildStates(GetSensorReadingResponseData data, SensorRecord sensorRecord) {
        if (data == null) {
            return "";
        }
        try {
            List<ReadingType> events;
            String deviceName;
            if (sensorRecord instanceof CompactSensorRecord) {
                CompactSensorRecord compactSensorRecord = (CompactSensorRecord)sensorRecord;
                deviceName = compactSensorRecord.getName();
                if (compactSensorRecord.getEventReadingType() == 127) {
                    return GetSensorsRunner.buildOemState(data.getRaw(), deviceName);
                }
                events = data.getStatesAsserted(compactSensorRecord.getSensorType(), compactSensorRecord.getEventReadingType());
            } else {
                FullSensorRecord fullSensorRecord = (FullSensorRecord)sensorRecord;
                deviceName = fullSensorRecord.getName();
                if (fullSensorRecord.getEventReadingType() == 127) {
                    return GetSensorsRunner.buildOemState(data.getRaw(), deviceName);
                }
                events = data.getStatesAsserted(fullSensorRecord.getSensorType(), fullSensorRecord.getEventReadingType());
            }
            return GetSensorsRunner.appendReadingTypes(events, deviceName);
        }
        catch (Exception e) {
            return "";
        }
    }

    static String buildOemState(byte[] raw, String deviceName) {
        if (raw == null || raw.length < 4) {
            throw new IllegalArgumentException(String.format("Invalid IPMI raw command date for device %s.", deviceName));
        }
        return String.format("%s=0x%02x%02x", deviceName, raw[3], raw[2]);
    }

    private static String appendReadingTypes(List<ReadingType> readingTypes, String deviceName) {
        return readingTypes.stream().map(readingType -> GetSensorsRunner.createStateEntry(deviceName, readingType)).filter(Objects::nonNull).collect(Collectors.toSet()).stream().collect(Collectors.joining("|"));
    }

    private static String createStateEntry(String deviceName, ReadingType readingType) {
        String state = ReadingTypeDescription.getReadingType(readingType);
        return state != null ? deviceName + "=" + state : null;
    }

    private GetSensorReadingResponseData getSensorRecordReading(int recordReadingId) throws Exception {
        block3: {
            try {
                if (recordReadingId >= 0) {
                    return (GetSensorReadingResponseData)this.connector.sendMessage(this.handle, new GetSensorReading(IpmiVersion.V20, this.handle.getCipherSuite(), AuthenticationType.RMCPPlus, recordReadingId));
                }
            }
            catch (IPMIException e) {
                if (e.getCompletionCode() == CompletionCode.DataNotPresent) break block3;
                throw e;
            }
        }
        return null;
    }

    private int getReadingId(SensorRecord sensorRecord) {
        if (sensorRecord instanceof FullSensorRecord) {
            FullSensorRecord fsr = (FullSensorRecord)sensorRecord;
            return TypeConverter.byteToInt(fsr.getSensorNumber());
        }
        if (sensorRecord instanceof CompactSensorRecord) {
            CompactSensorRecord csr = (CompactSensorRecord)sensorRecord;
            return TypeConverter.byteToInt(csr.getSensorNumber());
        }
        return -1;
    }
}

