/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.api.sol;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.async.InboundSolMessageListener;
import org.sentrysoftware.ipmi.core.api.sol.CipherSuiteSelectionHandler;
import org.sentrysoftware.ipmi.core.api.sol.SOLException;
import org.sentrysoftware.ipmi.core.api.sol.SolEventListener;
import org.sentrysoftware.ipmi.core.api.sol.SpecificCipherSuiteSelector;
import org.sentrysoftware.ipmi.core.api.sync.IpmiConnector;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.payload.ActivateSolPayload;
import org.sentrysoftware.ipmi.core.coding.commands.payload.ActivateSolPayloadResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.payload.DeactivatePayload;
import org.sentrysoftware.ipmi.core.coding.commands.payload.GetPayloadActivationStatus;
import org.sentrysoftware.ipmi.core.coding.commands.payload.GetPayloadActivationStatusResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.SetSessionPrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolAckState;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolOperation;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.sol.SolCoder;
import org.sentrysoftware.ipmi.core.coding.sol.SolResponseData;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.connection.Session;
import org.sentrysoftware.ipmi.core.connection.SessionException;
import org.sentrysoftware.ipmi.core.connection.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialOverLan
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(SerialOverLan.class);
    private final IpmiConnector connector;
    private final Session session;
    private final InboundSolMessageListener inboundMessageListener;
    private final List<SolEventListener> eventListeners;
    private boolean isSessionInternal;
    private int payloadInstance;
    private int maxPayloadSize;
    private boolean closed;

    public SerialOverLan(IpmiConnector connector, String remoteHost, int remotePort, String user, String password, CipherSuiteSelectionHandler cipherSuiteSelectionHandler) throws SOLException, SessionException {
        this(connector, SessionManager.establishSession(connector, remoteHost, remotePort, user, password, cipherSuiteSelectionHandler));
        this.isSessionInternal = true;
    }

    public SerialOverLan(IpmiConnector connector, String remoteHost, String user, String password, CipherSuiteSelectionHandler cipherSuiteSelectionHandler) throws SOLException, SessionException {
        this(connector, remoteHost, 623, user, password, cipherSuiteSelectionHandler);
    }

    public SerialOverLan(IpmiConnector connector, Session session) throws SOLException, SessionException {
        this.connector = connector;
        int solPayloadPort = this.activatePayload(connector, session.getConnectionHandle());
        this.session = this.resolveSession(connector, session.getConnectionHandle(), session, solPayloadPort);
        this.eventListeners = new LinkedList<SolEventListener>();
        this.inboundMessageListener = new InboundSolMessageListener(connector, this.session.getConnectionHandle(), this.eventListeners);
        connector.registerIncomingMessageListener(this.inboundMessageListener);
        this.closed = false;
    }

    private Session resolveSession(IpmiConnector connector, ConnectionHandle connectionHandle, Session session, int solPayloadPort) throws SOLException, SessionException {
        if (solPayloadPort != connectionHandle.getRemotePort()) {
            Session alternativeSession = connector.getExistingSessionForCriteria(connectionHandle.getRemoteAddress(), solPayloadPort, connectionHandle.getUser());
            if (alternativeSession == null) {
                SpecificCipherSuiteSelector cipherSuiteSelector = new SpecificCipherSuiteSelector(connectionHandle.getCipherSuite());
                alternativeSession = SessionManager.establishSession(connector, connectionHandle.getRemoteAddress().getHostAddress(), solPayloadPort, connectionHandle.getUser(), connectionHandle.getPassword(), cipherSuiteSelector);
                this.isSessionInternal = true;
            } else {
                this.isSessionInternal = false;
            }
            this.activatePayload(connector, alternativeSession.getConnectionHandle());
            return alternativeSession;
        }
        this.isSessionInternal = false;
        return session;
    }

    private int activatePayload(IpmiConnector connector, ConnectionHandle connectionHandle) throws SOLException {
        try {
            this.payloadInstance = this.getFirstAvailablePayloadInstance(connector, connectionHandle);
            ActivateSolPayload activatePayload = new ActivateSolPayload(connectionHandle.getCipherSuite(), this.payloadInstance);
            ActivateSolPayloadResponseData activatePayloadResponseData = this.getActivatePayloadResponse(connector, connectionHandle, activatePayload);
            this.maxPayloadSize = activatePayloadResponseData.getInboundPayloadSize();
            return activatePayloadResponseData.getPayloadUdpPortNumber();
        }
        catch (Exception e) {
            throw new SOLException("Cannot activate SOL payload due to exception during activation process", e);
        }
    }

    private ActivateSolPayloadResponseData getActivatePayloadResponse(IpmiConnector connector, ConnectionHandle connectionHandle, ActivateSolPayload activatePayload) throws Exception {
        ActivateSolPayloadResponseData activatePayloadResponseData;
        try {
            activatePayloadResponseData = (ActivateSolPayloadResponseData)connector.sendMessage(connectionHandle, activatePayload);
        }
        catch (IPMIException e) {
            if (e.getCompletionCode() == CompletionCode.InsufficentPrivilege) {
                this.raiseSessionPrivileges(connector, connectionHandle);
                activatePayloadResponseData = (ActivateSolPayloadResponseData)connector.sendMessage(connectionHandle, activatePayload);
            }
            throw e;
        }
        return activatePayloadResponseData;
    }

    private int getFirstAvailablePayloadInstance(IpmiConnector connector, ConnectionHandle connectionHandle) throws Exception {
        GetPayloadActivationStatus getPayloadActivationStatus = new GetPayloadActivationStatus(connectionHandle.getCipherSuite(), PayloadType.Sol);
        GetPayloadActivationStatusResponseData getActivationResponseData = (GetPayloadActivationStatusResponseData)connector.sendMessage(connectionHandle, getPayloadActivationStatus);
        if (getActivationResponseData.getInstanceCapacity() <= 0 || getActivationResponseData.getAvailableInstances().isEmpty()) {
            throw new SOLException("Cannot activate SOL payload, as there are no available payload instances.");
        }
        return TypeConverter.byteToInt(getActivationResponseData.getAvailableInstances().get(0));
    }

    private void raiseSessionPrivileges(IpmiConnector connector, ConnectionHandle connectionHandle) throws Exception {
        SetSessionPrivilegeLevel setSessionPrivilegeLevel = new SetSessionPrivilegeLevel(IpmiVersion.V20, connectionHandle.getCipherSuite(), AuthenticationType.RMCPPlus, PrivilegeLevel.Administrator);
        connector.sendMessage(connectionHandle, setSessionPrivilegeLevel);
    }

    public boolean writeByte(byte singleByte) {
        return this.writeBytes(new byte[]{singleByte});
    }

    public boolean writeBytes(byte[] buffer) {
        boolean result = true;
        int maxBufferSize = this.maxPayloadSize - 4;
        byte[] remainingBytes = buffer;
        int currentIndex = 0;
        while (remainingBytes.length - currentIndex > maxBufferSize) {
            byte[] bufferChunk = Arrays.copyOfRange(remainingBytes, currentIndex, maxBufferSize);
            currentIndex += maxBufferSize;
            if (result &= this.sendMessage(bufferChunk)) continue;
            return false;
        }
        if (remainingBytes.length - currentIndex > 0) {
            remainingBytes = Arrays.copyOfRange(remainingBytes, currentIndex, remainingBytes.length);
            result &= this.sendMessage(remainingBytes);
        }
        return result;
    }

    public boolean writeInt(int singleInt) {
        return this.writeBytes(new byte[]{TypeConverter.intToByte(singleInt)});
    }

    public boolean writeIntArray(int[] buffer) {
        byte[] byteBuffer = new byte[buffer.length];
        for (int i = 0; i < buffer.length; ++i) {
            byteBuffer[i] = TypeConverter.intToByte(buffer[i]);
        }
        return this.writeBytes(byteBuffer);
    }

    public boolean writeString(String string) {
        return this.writeBytes(string.getBytes());
    }

    public boolean writeString(String string, Charset charset) {
        return this.writeBytes(string.getBytes(charset));
    }

    public byte[] readBytes() {
        return this.readBytes(this.inboundMessageListener.getAvailableBytesCount());
    }

    public byte[] readBytes(int byteCount) {
        return this.inboundMessageListener.readBytes(byteCount);
    }

    public byte[] readBytes(int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readBytes(byteCount);
    }

    public int[] readIntArray() {
        return this.readIntArray(this.inboundMessageListener.getAvailableBytesCount());
    }

    public int[] readIntArray(int byteCount) {
        byte[] bytesArray = this.readBytes(byteCount);
        int[] intArray = new int[bytesArray.length];
        for (int i = 0; i < bytesArray.length; ++i) {
            intArray[i] = TypeConverter.byteToInt(bytesArray[i]);
        }
        return intArray;
    }

    public int[] readIntArray(int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readIntArray(byteCount);
    }

    public String readString() {
        return this.readString(this.inboundMessageListener.getAvailableBytesCount());
    }

    public String readString(int byteCount) {
        return new String(this.readBytes(byteCount));
    }

    public String readString(int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readString(byteCount);
    }

    public String readString(Charset charset) {
        return this.readString(charset, this.inboundMessageListener.getAvailableBytesCount());
    }

    public String readString(Charset charset, int byteCount) {
        return new String(this.readBytes(byteCount), charset);
    }

    public String readString(Charset charset, int byteCount, int timeout) {
        this.waitForData(byteCount, timeout);
        return this.readString(charset, byteCount);
    }

    private void waitForData(int wantedByteCount, int timeout) {
        long startTime = System.currentTimeMillis();
        while (this.isTooFewBytesAvailable(wantedByteCount) && this.timeoutNotHit(timeout, startTime)) {
        }
    }

    private boolean isTooFewBytesAvailable(int wantedByteCount) {
        return this.inboundMessageListener.getAvailableBytesCount() < wantedByteCount;
    }

    private boolean timeoutNotHit(int timeout, long startTime) {
        return System.currentTimeMillis() - startTime < (long)timeout;
    }

    public boolean invokeOperations(SolOperation ... operations) {
        HashSet<SolOperation> operationSet = new HashSet<SolOperation>();
        for (SolOperation operation : operations) {
            operationSet.add(operation);
        }
        return this.sendMessage(operationSet);
    }

    public void registerEventListener(SolEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void unregisterEventListener(SolEventListener listener) {
        this.eventListeners.remove(listener);
    }

    private boolean sendMessage(byte[] characterData) {
        SolCoder payloadCoder = new SolCoder(characterData, this.session.getConnectionHandle().getCipherSuite());
        SolResponseData responseData = this.sendPayload(payloadCoder);
        this.notifyResponseListeners(characterData, new HashSet<SolOperation>(), responseData);
        byte[] remainingCharacterData = characterData;
        while (this.isNackForMessagePart(responseData, remainingCharacterData.length)) {
            remainingCharacterData = Arrays.copyOfRange(remainingCharacterData, (int)responseData.getAcceptedCharactersNumber(), remainingCharacterData.length);
            SolCoder partialPayloadCoder = new SolCoder(remainingCharacterData, this.session.getConnectionHandle().getCipherSuite());
            responseData = this.sendPayload(partialPayloadCoder);
            this.notifyResponseListeners(remainingCharacterData, new HashSet<SolOperation>(), responseData);
        }
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.ACK;
    }

    private boolean sendMessage(Set<SolOperation> operations) {
        SolCoder payloadCoder = new SolCoder(operations, this.session.getConnectionHandle().getCipherSuite());
        SolResponseData responseData = this.sendPayload(payloadCoder);
        this.notifyResponseListeners(new byte[0], operations, responseData);
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.ACK;
    }

    private void notifyResponseListeners(byte[] characterData, Set<SolOperation> solOperations, SolResponseData responseData) {
        if (responseData != null && responseData.getStatuses() != null && !responseData.getStatuses().isEmpty()) {
            for (SolEventListener listener : this.eventListeners) {
                listener.processResponseEvent(responseData.getStatuses(), characterData, solOperations);
            }
        }
    }

    private SolResponseData sendPayload(PayloadCoder payloadCoder) {
        ConnectionHandle connectionHandle = this.session.getConnectionHandle();
        try {
            SolResponseData responseData = (SolResponseData)this.connector.sendMessage(connectionHandle, payloadCoder);
            for (int actualRetries = 0; this.isNackForWholeMessage(responseData) && actualRetries < this.connector.getRetries(); ++actualRetries) {
                responseData = (SolResponseData)this.connector.retryMessage(connectionHandle, responseData.getRequestSequenceNumber(), PayloadType.Sol);
            }
            return responseData;
        }
        catch (Exception e) {
            logger.error("Error while sending message", (Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                ConnectionHandle connectionHandle = this.session.getConnectionHandle();
                DeactivatePayload deactivatePayload = new DeactivatePayload(connectionHandle.getCipherSuite(), PayloadType.Sol, this.payloadInstance);
                this.connector.sendMessage(connectionHandle, deactivatePayload);
                if (this.isSessionInternal) {
                    this.connector.closeSession(connectionHandle);
                    this.connector.tearDown();
                }
                this.closed = true;
            }
            catch (Exception e) {
                throw new IOException("Error while closing Serial over LAN instance", e);
            }
        }
    }

    private boolean isNackForWholeMessage(SolResponseData responseData) {
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.NACK && responseData.getAcceptedCharactersNumber() == 0;
    }

    private boolean isNackForMessagePart(SolResponseData responseData, int previousMessageDataLength) {
        return responseData != null && responseData.getAcknowledgeState() == SolAckState.NACK && responseData.getAcceptedCharactersNumber() > 0 && responseData.getAcceptedCharactersNumber() < previousMessageDataLength;
    }
}

