/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.crypto.NoSuchPaddingException;
import org.sentrysoftware.ipmi.core.coding.Decoder;
import org.sentrysoftware.ipmi.core.coding.Encoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.GetChassisStatus;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.GetChassisStatusResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.BaseUnit;
import org.sentrysoftware.ipmi.core.coding.commands.fru.GetFruInventoryAreaInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.GetFruInventoryAreaInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.ReadFruData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.ReadFruDataResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.BoardInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ChassisInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruRecord;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ProductInfo;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdr;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdrRepositoryInfo;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdrRepositoryInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdrResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSensorReading;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSensorReadingResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.ReserveSdrRepository;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.ReserveSdrRepositoryResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.CompactSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.FruDeviceLocatorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.FullSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.RateUnit;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.ReadingType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sel.GetSelEntry;
import org.sentrysoftware.ipmi.core.coding.commands.sel.GetSelEntryResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sel.GetSelInfo;
import org.sentrysoftware.ipmi.core.coding.commands.sel.GetSelInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sel.ReserveSel;
import org.sentrysoftware.ipmi.core.coding.commands.sel.ReserveSelResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sel.SelRecord;
import org.sentrysoftware.ipmi.core.coding.commands.session.CloseSession;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilities;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelCipherSuites;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelCipherSuitesResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.OpenSession;
import org.sentrysoftware.ipmi.core.coding.commands.session.OpenSessionResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp3;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp3ResponseData;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.PlainCommandv20Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv15Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv20Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv15Encoder;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv20Encoder;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderRunner
extends Thread {
    private DatagramSocket socket;
    private static int managedSeqNum;
    private static boolean lock;
    private static Rakp1 r1;
    private static Rakp1ResponseData r1rd;
    private static CipherSuite cs;
    private static Logger logger;
    private static int cssrcv;
    private static int reservation;
    private static int nextRecId;
    private static byte[] cssrec;
    private static int fruId;
    private static int fruSize;

    public static void main(String[] args) throws IOException, InterruptedException, NoSuchAlgorithmException, InvalidKeyException {
        int sequence;
        logger.info(DateFormat.getInstance().format(new Date(new Date().getTime())));
        lock = true;
        DecoderRunner dr = new DecoderRunner();
        dr.socket = new DatagramSocket(6666);
        dr.start();
        Properties properties = new Properties();
        properties.load(new FileInputStream("src/test/resources/test.properties"));
        Thread.sleep(100L);
        InetAddress ad = InetAddress.getByName((String)properties.get("testIp"));
        byte index = 0;
        while (cssrcv >= 16) {
            Thread.sleep(300L);
            lock = true;
            byte[] outmsg = Encoder.encode(new Protocolv20Encoder(), new GetChannelCipherSuites(TypeConverter.intToByte(14), index), 0, 0, 0);
            index = (byte)(index + 1);
            DatagramPacket packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            while (lock) {
                Thread.sleep(1L);
            }
        }
        List<CipherSuite> csl = CipherSuite.getCipherSuites(cssrec);
        for (CipherSuite c : csl) {
            try {
                logger.info(c.getId() + ": " + c.getAuthenticationAlgorithm().getCode() + " " + c.getIntegrityAlgorithm().getCode() + " " + c.getConfidentialityAlgorithm().getCode());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        cs = csl.get(2);
        Thread.sleep(300L);
        byte[] outmsg = Encoder.encode(new Protocolv15Encoder(), new GetChannelAuthenticationCapabilities(IpmiVersion.V15, IpmiVersion.V20, cs, PrivilegeLevel.User, TypeConverter.intToByte(14)), 0, 0, 0);
        DatagramPacket packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(150L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new OpenSession(44, PrivilegeLevel.MaximumAvailable, cs), 0, 0, 0);
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        while (lock) {
            Thread.sleep(1L);
        }
        lock = true;
        r1 = new Rakp1(managedSeqNum, PrivilegeLevel.User, (String)properties.get("username"), (String)properties.get("password"), null, cs);
        outmsg = Encoder.encode(new Protocolv20Encoder(), r1, 1, 1, 0);
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(150L);
        while (lock) {
            Thread.sleep(1L);
        }
        try {
            cs.initializeAlgorithms(r1.calculateSik(r1rd));
        }
        catch (NoSuchPaddingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        outmsg = Encoder.encode(new Protocolv20Encoder(), new Rakp3(0, managedSeqNum, cs, r1, r1rd), 1, 1, 0);
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(150L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetChassisStatus(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), 1, 1, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSdrRepositoryInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), 2, 2, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        outmsg = Encoder.encode(new Protocolv20Encoder(), new ReserveSdrRepository(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), 3, 3, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        int seq = 4;
        lock = true;
        while (lock) {
            Thread.sleep(1L);
        }
        while (nextRecId < 65535) {
            Thread.sleep(200L);
            logger.info(">>Sending request for record " + nextRecId);
            sequence = seq++;
            outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSdr(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, reservation, nextRecId), sequence, sequence, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            lock = true;
            while (lock) {
                Thread.sleep(1L);
            }
            if (nextRecId <= 0) continue;
            logger.info(">>Sending request for reading " + nextRecId);
            sequence = seq++;
            outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSensorReading(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, nextRecId), sequence, sequence, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            lock = true;
            while (lock && nextRecId < 65535) {
                Thread.sleep(1L);
            }
        }
        nextRecId = 0;
        Thread.sleep(300L);
        logger.info(">>Sending GetSelInfo");
        sequence = seq++;
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSelInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), sequence, sequence, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(300L);
        logger.info(">>Sending Reserve SEL");
        sequence = seq++;
        outmsg = Encoder.encode(new Protocolv20Encoder(), new ReserveSel(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus), sequence, sequence, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        lock = true;
        while (lock) {
            Thread.sleep(1L);
        }
        while (nextRecId < 65535) {
            Thread.sleep(200L);
            logger.info(">>Sending request for SEL record " + nextRecId);
            sequence = seq++;
            outmsg = Encoder.encode(new Protocolv20Encoder(), new GetSelEntry(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, reservation, nextRecId), sequence, sequence, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
            lock = true;
            while (lock) {
                Thread.sleep(1L);
            }
        }
        Thread.sleep(300L);
        logger.info(">>Sending GetFruInventoryAreaInfo");
        sequence = seq++;
        outmsg = Encoder.encode(new Protocolv20Encoder(), new GetFruInventoryAreaInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, fruId), sequence, sequence, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        for (int i = 0; i < fruSize; i += 100) {
            Thread.sleep(300L);
            logger.info(">>Sending ReadFruData");
            int cnt = 100;
            if (i + cnt > fruSize) {
                cnt = fruSize % 100;
            }
            sequence = seq++;
            outmsg = Encoder.encode(new Protocolv20Encoder(), new ReadFruData(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, fruId, BaseUnit.Bytes, i, cnt), sequence, sequence, r1.getManagedSystemSessionId());
            packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
            dr.socket.send(packet);
        }
        Thread.sleep(300L);
        sequence = seq + 1;
        outmsg = Encoder.encode(new Protocolv20Encoder(), new CloseSession(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, r1.getManagedSystemSessionId()), sequence, sequence, r1.getManagedSystemSessionId());
        packet = new DatagramPacket(outmsg, outmsg.length, ad, 623);
        dr.socket.send(packet);
        Thread.sleep(1000L);
        dr.socket.close();
    }

    @Override
    public void run() {
        Object rec;
        ResponseData data;
        DatagramPacket resp;
        super.run();
        cssrec = new byte[0];
        byte[] buffer = null;
        while (cssrcv >= 16) {
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            data = null;
            try {
                data = (GetChannelCipherSuitesResponseData)Decoder.decode(buffer, new Protocolv20Decoder(CipherSuite.getEmpty()), new GetChannelCipherSuites());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (data != null && ((GetChannelCipherSuitesResponseData)data).getCipherSuiteData() != null) {
                cssrcv = ((GetChannelCipherSuitesResponseData)data).getCipherSuiteData().length;
                logger.info("{}", (Object)((GetChannelCipherSuitesResponseData)data).getCipherSuiteData().length);
                byte[] temp = new byte[cssrec.length + cssrcv];
                System.arraycopy(cssrec, 0, temp, 0, cssrec.length);
                System.arraycopy(((GetChannelCipherSuitesResponseData)data).getCipherSuiteData(), 0, temp, cssrec.length, cssrcv);
                cssrec = temp;
            } else {
                cssrcv = 0;
                logger.info("{}", (Object)0);
            }
            lock = false;
        }
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        data = null;
        try {
            data = (GetChannelAuthenticationCapabilitiesResponseData)Decoder.decode(buffer, new Protocolv15Decoder(), new GetChannelAuthenticationCapabilities(IpmiVersion.V15, IpmiVersion.V20, cs));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("---------------------------------------------");
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getChannelNumber());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isIpmiv20Support());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getAuthenticationTypes().toString());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isKgEnabled());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isPerMessageAuthenticationEnabled());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isUserLevelAuthenticationEnabled());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isNonNullUsernamesEnabled());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isNullUsernamesEnabled());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).isAnonymusLoginEnabled());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getOemId());
        logger.info("{}", (Object)((GetChannelAuthenticationCapabilitiesResponseData)data).getOemData());
        logger.info("##############################################");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            logger.info(">>>> " + resp.getLength());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        OpenSessionResponseData data2 = null;
        try {
            data2 = (OpenSessionResponseData)Decoder.decode(buffer, new PlainCommandv20Decoder(CipherSuite.getEmpty()), new OpenSession(CipherSuite.getEmpty()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data2.getMessageTag());
        logger.info("{}", (Object)data2.getStatusCode());
        logger.info("{}", (Object)data2.getPrivilegeLevel());
        logger.info("{}", (Object)data2.getRemoteConsoleSessionId());
        logger.info("{}", (Object)data2.getManagedSystemSessionId());
        logger.info("{}", (Object)data2.getAuthenticationAlgorithm());
        logger.info("{}", (Object)data2.getConfidentialityAlgorithm());
        logger.info("{}", (Object)data2.getIntegrityAlgorithm());
        managedSeqNum = data2.getManagedSystemSessionId();
        lock = false;
        logger.info("---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Rakp1ResponseData data3 = null;
        try {
            data3 = (Rakp1ResponseData)Decoder.decode(buffer, new PlainCommandv20Decoder(CipherSuite.getEmpty()), r1);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        r1rd = data3;
        logger.info("{}", (Object)data3.getMessageTag());
        logger.info("{}", (Object)data3.getStatusCode());
        logger.info("{}", (Object)data3.getRemoteConsoleSessionId());
        logger.info("{}", (Object)data3.getManagedSystemGuid());
        logger.info("---------------------------------------------");
        lock = false;
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Rakp3ResponseData data4 = null;
        try {
            data4 = (Rakp3ResponseData)Decoder.decode(buffer, new PlainCommandv20Decoder(CipherSuite.getEmpty()), new Rakp3(cs, r1, r1rd));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data4.getMessageTag());
        logger.info("{}", (Object)data4.getStatusCode());
        logger.info("{}", (Object)data4.getConsoleSessionId());
        logger.info("---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetChassisStatusResponseData data5 = null;
        try {
            data5 = (GetChassisStatusResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetChassisStatus(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data5.getPowerRestorePolicy());
        logger.info("{}", (Object)data5.isPowerControlFault());
        logger.info("{}", (Object)data5.isPowerFault());
        logger.info("{}", (Object)data5.isInterlock());
        logger.info("{}", (Object)data5.isPowerOverload());
        logger.info("{}", (Object)data5.isPowerOn());
        logger.info("________");
        logger.info("{}", (Object)data5.wasIpmiPowerOn());
        logger.info("{}", (Object)data5.wasPowerFault());
        logger.info("{}", (Object)data5.wasInterlock());
        logger.info("{}", (Object)data5.wasPowerOverload());
        logger.info("________");
        logger.info("{}", (Object)data5.isChassisIdentifyCommandSupported());
        if (data5.isChassisIdentifyCommandSupported()) {
            logger.info("{}", (Object)data5.getChassisIdentifyState());
        }
        logger.info("{}", (Object)data5.coolingFaultDetected());
        logger.info("{}", (Object)data5.driveFaultDetected());
        logger.info("{}", (Object)data5.isFrontPanelLockoutActive());
        logger.info("{}", (Object)data5.isChassisIntrusionActive());
        logger.info("________");
        logger.info("{}", (Object)data5.isFrontPanelButtonCapabilitiesSet());
        if (data5.isFrontPanelButtonCapabilitiesSet()) {
            try {
                logger.info("{}", (Object)data5.isStandbyButtonDisableAllowed());
                logger.info("{}", (Object)data5.isDiagnosticInterruptButtonDisableAllowed());
                logger.info("{}", (Object)data5.isResetButtonDisableAllowed());
                logger.info("{}", (Object)data5.isPowerOffButtonDisableAllowed());
                logger.info("{}", (Object)data5.isStandbyButtonDisabled());
                logger.info("{}", (Object)data5.isDiagnosticInterruptButtonDisabled());
                logger.info("{}", (Object)data5.isResetButtonDisabled());
                logger.info("{}", (Object)data5.isPowerOffButtonDisabled());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetSdrRepositoryInfoResponseData data6 = null;
        try {
            data6 = (GetSdrRepositoryInfoResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSdrRepositoryInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data6.getSdrVersion());
        logger.info("{}", (Object)data6.getRecordCount());
        logger.info("{}", (Object)data6.getAddTimestamp());
        logger.info("{}", (Object)data6.getDelTimestamp());
        logger.info("{}", (Object)data6.isReserveSupported());
        logger.info("---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ReserveSdrRepositoryResponseData data7 = null;
        try {
            data7 = (ReserveSdrRepositoryResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new ReserveSdrRepository(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data7.getReservationId());
        reservation = data7.getReservationId();
        logger.info("<<Received ReserveSdrRepo response");
        lock = false;
        logger.info("---------------------------------------------");
        while (nextRecId < 65535) {
            SensorRecord rec2;
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            GetSdrResponseData data8 = null;
            try {
                data8 = (GetSdrResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSdr(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0, 0));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            SensorRecord record = SensorRecord.populateSensorRecord(data8.getSensorRecordData());
            logger.info(record.toString());
            nextRecId = record instanceof FullSensorRecord ? TypeConverter.byteToInt(((FullSensorRecord)record).getSensorNumber()) : (record instanceof CompactSensorRecord ? TypeConverter.byteToInt(((CompactSensorRecord)record).getSensorNumber()) : -1);
            logger.info("<<Reading Id " + nextRecId);
            if (record instanceof FullSensorRecord) {
                rec2 = (FullSensorRecord)record;
                logger.info("*" + ((FullSensorRecord)rec2).getName());
                logger.info("Reading type: " + ((FullSensorRecord)rec2).getEventReadingType());
                logger.info("Lower critical threshold: " + ((FullSensorRecord)rec2).getLowerCriticalThreshold());
                logger.info("Upper critical threshold: " + ((FullSensorRecord)rec2).getUpperCriticalThreshold());
                logger.info("Tolerance: +/- " + ((FullSensorRecord)rec2).getTolerance() + " " + ((FullSensorRecord)rec2).getSensorBaseUnit().toString() + (((FullSensorRecord)rec2).getRateUnit() != RateUnit.None ? " per " + (Object)((Object)((FullSensorRecord)rec2).getRateUnit()) : ""));
                logger.info("Resolution: " + ((FullSensorRecord)rec2).getSensorResolution() + " " + ((FullSensorRecord)rec2).getSensorBaseUnit().toString() + (((FullSensorRecord)rec2).getRateUnit() != RateUnit.None ? " per " + (Object)((Object)((FullSensorRecord)rec2).getRateUnit()) : ""));
            }
            if (record instanceof CompactSensorRecord) {
                rec2 = (CompactSensorRecord)record;
                logger.info("*" + ((CompactSensorRecord)rec2).getName());
                logger.info("Reading type: " + ((CompactSensorRecord)rec2).getEventReadingType());
                logger.info("Sensor type: " + (Object)((Object)((CompactSensorRecord)rec2).getSensorType()));
            }
            if (record instanceof FruDeviceLocatorRecord) {
                rec2 = (FruDeviceLocatorRecord)record;
                logger.info(((FruDeviceLocatorRecord)rec2).getName());
                logger.info("{}", (Object)((FruDeviceLocatorRecord)rec2).getDeviceType());
                logger.info("FRU entity ID: " + ((FruDeviceLocatorRecord)rec2).getFruEntityId());
                logger.info("FRU access address: " + ((FruDeviceLocatorRecord)rec2).getDeviceAccessAddress());
                logger.info("FRU device ID: " + ((FruDeviceLocatorRecord)rec2).getDeviceId());
                logger.info("FRU logical: " + ((FruDeviceLocatorRecord)rec2).isLogical());
            }
            lock = false;
            if (nextRecId > 0) {
                resp = new DatagramPacket(new byte[256], 256);
                try {
                    this.socket.receive(resp);
                    buffer = new byte[resp.getLength()];
                    System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                GetSensorReadingResponseData data9 = null;
                try {
                    data9 = (GetSensorReadingResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSensorReading(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0));
                    if (record instanceof FullSensorRecord) {
                        rec = (FullSensorRecord)record;
                        logger.info(data9.getSensorReading((FullSensorRecord)rec) + " " + ((FullSensorRecord)rec).getSensorBaseUnit().toString() + (((FullSensorRecord)rec).getRateUnit() != RateUnit.None ? " per " + (Object)((Object)((FullSensorRecord)rec).getRateUnit()) : ""));
                    }
                    if (record instanceof CompactSensorRecord) {
                        rec = (CompactSensorRecord)record;
                        List<ReadingType> events = data9.getStatesAsserted(((CompactSensorRecord)rec).getSensorType(), ((CompactSensorRecord)rec).getEventReadingType());
                        StringBuilder s = new StringBuilder();
                        for (int i = 0; i < events.size(); ++i) {
                            s.append((Object)events.get(i)).append(", ");
                        }
                        logger.info(s.toString());
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            nextRecId = data8.getNextRecordId();
            logger.info("---------------------------------------------");
            lock = false;
        }
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetSelInfoResponseData data10 = null;
        try {
            data10 = (GetSelInfoResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSelInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data10.getSelVersion());
        logger.info("{}", (Object)data10.getEntriesCount());
        logger.info(DateFormat.getInstance().format(data10.getAdditionTimestamp()));
        logger.info(DateFormat.getInstance().format(data10.getEraseTimestamp()));
        logger.info("---------------------------------------------");
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ReserveSelResponseData data11 = null;
        try {
            data11 = (ReserveSelResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new ReserveSel(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("{}", (Object)data11.getReservationId());
        reservation = data11.getReservationId();
        reservation = 0;
        lock = false;
        logger.info("---------------------------------------------");
        while (nextRecId < 65535) {
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            GetSelEntryResponseData data12 = null;
            try {
                data12 = (GetSelEntryResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetSelEntry(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0, 0));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            logger.info(data12.getSelRecord().toString());
            rec = data12.getSelRecord();
            logger.info("Sensor: " + (Object)((Object)((SelRecord)rec).getSensorType()));
            logger.info("{}", (Object)((SelRecord)rec).getTimestamp());
            logger.info("{}", (Object)((SelRecord)rec).getEventDirection());
            logger.info("{}", (Object)((SelRecord)rec).getEvent());
            nextRecId = data12.getNextRecordId();
            lock = false;
            logger.info("---------------------------------------------");
        }
        resp = new DatagramPacket(new byte[256], 256);
        try {
            this.socket.receive(resp);
            buffer = new byte[resp.getLength()];
            System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        GetFruInventoryAreaInfoResponseData data13 = null;
        try {
            data13 = (GetFruInventoryAreaInfoResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new GetFruInventoryAreaInfo(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("FRU inventory area size: " + data13.getFruInventoryAreaSize());
        logger.info("FRU Unit: " + (Object)((Object)data13.getFruUnit()));
        logger.info("---------------------------------------------");
        ArrayList<ReadFruDataResponseData> rd = new ArrayList<ReadFruDataResponseData>();
        for (int i = 0; i < fruSize; i += 100) {
            resp = new DatagramPacket(new byte[256], 256);
            try {
                this.socket.receive(resp);
                buffer = new byte[resp.getLength()];
                System.arraycopy(resp.getData(), 0, buffer, 0, buffer.length);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ReadFruDataResponseData data14 = null;
            try {
                data14 = (ReadFruDataResponseData)Decoder.decode(buffer, new Protocolv20Decoder(cs), new ReadFruData(IpmiVersion.V20, cs, AuthenticationType.RMCPPlus, 0, BaseUnit.Bytes, 0, 0));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            rd.add(data14);
            logger.info("{}", (Object)data14.getFruData().length);
            logger.info("---------------------------------------------");
        }
        List<FruRecord> records = ReadFruData.decodeFruData(rd);
        for (FruRecord r : records) {
            if (r instanceof ChassisInfo) {
                ChassisInfo chassisInfo = (ChassisInfo)r;
                logger.info("Chassis info:");
                logger.info("Chassis type: " + (Object)((Object)chassisInfo.getChassisType()));
                logger.info("Chassis part number: " + chassisInfo.getChassisPartNumber());
                logger.info("Chassis serial number: " + chassisInfo.getChassisSerialNumber());
                for (String info : chassisInfo.getCustomChassisInfo()) {
                    logger.info("Custom chassis info: " + info);
                }
                logger.info("---------------------------------------------");
                continue;
            }
            if (r instanceof BoardInfo) {
                BoardInfo boardInfo = (BoardInfo)r;
                logger.info("Board info:");
                logger.info("Board MFG date: " + boardInfo.getMfgDate().toString());
                logger.info("Board manufacturer: " + boardInfo.getBoardManufacturer());
                logger.info("Board product name: " + boardInfo.getBoardProductName());
                logger.info("Board part number: " + boardInfo.getBoardPartNumber());
                logger.info("Board serial number: " + boardInfo.getBoardSerialNumber());
                for (String info : boardInfo.getCustomBoardInfo()) {
                    logger.info("Custom board info: " + info);
                }
                logger.info("---------------------------------------------");
                continue;
            }
            if (!(r instanceof ProductInfo)) continue;
            ProductInfo productInfo = (ProductInfo)r;
            logger.info("Product info:");
            logger.info("Product manufacturer: " + productInfo.getManufacturerName());
            logger.info("Product product name: " + productInfo.getProductName());
            logger.info("Product part number: " + productInfo.getProductModelNumber());
            logger.info("Product version: " + productInfo.getProductVersion());
            logger.info("Product serial number: " + productInfo.getProductSerialNumber());
            logger.info("Product asset tag: " + productInfo.getAssetTag());
            for (String info : productInfo.getCustomProductInfo()) {
                logger.info("Custom board info: " + info);
            }
            logger.info("---------------------------------------------");
        }
    }

    static {
        cs = new CipherSuite(0, 1, 0, 0);
        logger = LoggerFactory.getLogger(DecoderRunner.class);
        cssrcv = 16;
        nextRecId = 0;
        fruId = 0;
        fruSize = 528;
    }
}

