/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands;

import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.PlainMessage;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;

public abstract class IpmiCommandCoder
extends PayloadCoder {
    public IpmiCommandCoder() {
    }

    public IpmiCommandCoder(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(version, cipherSuite, authenticationType);
    }

    @Override
    public PayloadType getSupportedPayloadType() {
        return PayloadType.Ipmi;
    }

    public boolean isCommandResponse(IpmiMessage message) {
        if (message.getPayload() instanceof IpmiPayload) {
            if (message.getPayload() instanceof IpmiLanResponse) {
                return ((IpmiLanResponse)message.getPayload()).getCommand() == this.getCommandCode();
            }
            return message.getPayload() instanceof PlainMessage;
        }
        return false;
    }

    public abstract byte getCommandCode();

    public abstract NetworkFunction getNetworkFunction();

    protected byte encodePrivilegeLevel(PrivilegeLevel privilegeLevel) {
        switch (privilegeLevel) {
            case MaximumAvailable: {
                return 0;
            }
            case Callback: {
                return 1;
            }
            case User: {
                return 2;
            }
            case Operator: {
                return 3;
            }
            case Administrator: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid privilege level");
    }
}

