/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.chassis;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.chassis.GetChassisStatusResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanMessage;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetChassisStatus
extends IpmiCommandCoder {
    public GetChassisStatus(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(version, cipherSuite, authenticationType);
        if (version == IpmiVersion.V20 && authenticationType != AuthenticationType.RMCPPlus) {
            throw new IllegalArgumentException("Authentication Type must be RMCPPlus for IPMI v2.0 messages");
        }
    }

    @Override
    protected IpmiLanMessage preparePayload(int sequenceNumber) {
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), null, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public byte getCommandCode() {
        return 1;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ChassisRequest;
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get Chassis Status command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length != 3 && raw.length != 4) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetChassisStatusResponseData responseData = new GetChassisStatusResponseData();
        responseData.setCurrentPowerState(raw[0]);
        responseData.setLastPowerEvent(raw[1]);
        responseData.setMiscChassisState(raw[2]);
        if (raw.length == 4) {
            responseData.setFrontPanelButtonCapabilities(raw[3]);
        }
        return responseData;
    }
}

