/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.BaseUnit;
import org.sentrysoftware.ipmi.core.coding.commands.fru.ReadFruDataResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.BoardInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ChassisInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruRecord;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.MultiRecordInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ProductInfo;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class ReadFruData
extends IpmiCommandCoder {
    private int offset;
    private int size;
    private int fruId;

    public ReadFruData(int fruId, BaseUnit unit, int offset, int countToRead) {
        if (countToRead > 255) {
            throw new IllegalArgumentException("Count to read cannot exceed 255");
        }
        if (fruId > 255) {
            throw new IllegalArgumentException("FRU ID cannot exceed 255");
        }
        this.offset = offset * unit.getSize();
        this.size = countToRead * unit.getSize();
        this.fruId = fruId;
    }

    public ReadFruData(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int fruId, BaseUnit unit, int offset, int countToRead) {
        super(version, cipherSuite, authenticationType);
        if (countToRead > 255) {
            throw new IllegalArgumentException("Count to read cannot exceed 255");
        }
        if (fruId > 255) {
            throw new IllegalArgumentException("FRU ID cannot exceed 255");
        }
        this.offset = offset * unit.getSize();
        this.size = countToRead * unit.getSize();
        this.fruId = fruId;
    }

    @Override
    public byte getCommandCode() {
        return 17;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payload = new byte[4];
        payload[0] = TypeConverter.intToByte(this.fruId);
        byte[] buffer = TypeConverter.intToLittleEndianByteArray(this.offset);
        payload[1] = buffer[0];
        payload[2] = buffer[1];
        payload[3] = TypeConverter.intToByte(this.size);
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SDR Repository Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length < 2) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        ReadFruDataResponseData responseData = new ReadFruDataResponseData();
        int sizeFromResponse = TypeConverter.byteToInt(raw[0]);
        byte[] fruData = new byte[sizeFromResponse];
        System.arraycopy(raw, 1, fruData, 0, sizeFromResponse);
        responseData.setFruData(fruData);
        return responseData;
    }

    public static List<FruRecord> decodeFruData(List<ReadFruDataResponseData> fruData) {
        int size = 0;
        ArrayList<FruRecord> list = new ArrayList<FruRecord>();
        for (ReadFruDataResponseData responseData : fruData) {
            size += responseData.getFruData().length;
        }
        byte[] data = new byte[size];
        int offset = 0;
        for (ReadFruDataResponseData responseData : fruData) {
            int length = responseData.getFruData().length;
            System.arraycopy(responseData.getFruData(), 0, data, offset, length);
            offset += length;
        }
        if (data[0] == 1) {
            int chassisOffset = TypeConverter.byteToInt(data[2]) * 8;
            int boardOffset = TypeConverter.byteToInt(data[3]) * 8;
            int productInfoOffset = TypeConverter.byteToInt(data[4]) * 8;
            int multiRecordOffset = TypeConverter.byteToInt(data[5]) * 8;
            if (chassisOffset != 0) {
                list.add(new ChassisInfo(data, chassisOffset));
            }
            if (boardOffset != 0) {
                list.add(new BoardInfo(data, boardOffset));
            }
            if (productInfoOffset != 0) {
                list.add(new ProductInfo(data, productInfoOffset));
            }
            if (multiRecordOffset != 0) {
                ReadFruData.addMultirecords(list, data, multiRecordOffset);
            }
        } else {
            throw new IllegalArgumentException("Invalid format version: " + data[0]);
        }
        return list;
    }

    private static void addMultirecords(ArrayList<FruRecord> list, byte[] data, int multiRecordOffset) {
        int currentMultirecordOffset = multiRecordOffset;
        while ((TypeConverter.byteToInt(data[currentMultirecordOffset + 1]) & 0x80) == 0) {
            list.add(MultiRecordInfo.populateMultiRecord(data, currentMultirecordOffset));
            currentMultirecordOffset += TypeConverter.byteToInt(data[currentMultirecordOffset + 2]) + 5;
        }
    }
}

