/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru.record;

import java.util.ArrayList;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ChassisType;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruRecord;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class ChassisInfo
extends FruRecord {
    private ChassisType chassisType;
    private String chassisPartNumber = "";
    private String chassisSerialNumber = "";
    private String[] customChassisInfo = new String[0];

    public ChassisInfo(byte[] fruData, int offset) {
        if (fruData[offset] != 1) {
            throw new IllegalArgumentException("Invalid format version");
        }
        this.chassisType = ChassisType.parseInt(TypeConverter.byteToInt(fruData[offset + 2]));
        int partNumber = TypeConverter.byteToInt(fruData[offset + 3]);
        int currentOffset = offset + 4;
        int index = 0;
        ArrayList<String> customInfo = new ArrayList<String>();
        block4: while (partNumber != 193 && currentOffset < fruData.length) {
            int partType = (partNumber & 0xC0) >> 6;
            int partDataLength = partNumber & 0x3F;
            if (partDataLength > 0 && partDataLength + currentOffset < fruData.length) {
                byte[] partNumberData = new byte[partDataLength];
                System.arraycopy(fruData, currentOffset, partNumberData, 0, partDataLength);
                currentOffset += partDataLength;
                switch (index) {
                    case 0: {
                        this.setChassisPartNumber(FruRecord.decodeString(partType, partNumberData, true));
                        break;
                    }
                    case 1: {
                        this.setChassisSerialNumber(FruRecord.decodeString(partType, partNumberData, true));
                        break;
                    }
                    default: {
                        if (partDataLength == 0) continue block4;
                        customInfo.add(FruRecord.decodeString(partType, partNumberData, true));
                    }
                }
            }
            partNumber = TypeConverter.byteToInt(fruData[currentOffset]);
            ++currentOffset;
            ++index;
        }
        this.customChassisInfo = new String[customInfo.size()];
        this.customChassisInfo = customInfo.toArray(this.customChassisInfo);
    }

    public ChassisType getChassisType() {
        return this.chassisType;
    }

    public void setChassisType(ChassisType chassisType) {
        this.chassisType = chassisType;
    }

    public String getChassisPartNumber() {
        return this.chassisPartNumber;
    }

    public void setChassisPartNumber(String chassisPartNumber) {
        this.chassisPartNumber = chassisPartNumber;
    }

    public String getChassisSerialNumber() {
        return this.chassisSerialNumber;
    }

    public void setChassisSerialNumber(String chassisSerialNumber) {
        this.chassisSerialNumber = chassisSerialNumber;
    }

    public String[] getCustomChassisInfo() {
        return this.customChassisInfo;
    }
}

