/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru.record;

import org.sentrysoftware.ipmi.core.coding.commands.fru.record.MultiRecordInfo;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class DcOutputInfo
extends MultiRecordInfo {
    private int outputNumber;
    private int nominalVoltage;
    private int maximumNegativeDeviation;
    private int maximumPositiveDeviation;

    public DcOutputInfo(byte[] fruData, int offset) {
        this.outputNumber = TypeConverter.byteToInt(fruData[offset]) & 0xF;
        this.nominalVoltage = TypeConverter.byteToInt(fruData[offset + 1]);
        this.nominalVoltage |= TypeConverter.byteToInt(fruData[offset + 2]) << 8;
        this.nominalVoltage = TypeConverter.decode2sComplement(this.nominalVoltage, 15);
        this.maximumNegativeDeviation = TypeConverter.byteToInt(fruData[offset + 3]);
        this.maximumNegativeDeviation |= TypeConverter.byteToInt(fruData[offset + 4]) << 8;
        this.maximumNegativeDeviation = TypeConverter.decode2sComplement(this.maximumNegativeDeviation, 15);
        this.maximumPositiveDeviation = TypeConverter.byteToInt(fruData[offset + 5]);
        this.maximumPositiveDeviation |= TypeConverter.byteToInt(fruData[offset + 6]) << 8;
        this.maximumPositiveDeviation = TypeConverter.decode2sComplement(this.maximumPositiveDeviation, 15);
    }

    public int getOutputNumber() {
        return this.outputNumber;
    }

    public void setOutputNumber(int outputNumber) {
        this.outputNumber = outputNumber;
    }

    public int getNominalVoltage() {
        return this.nominalVoltage;
    }

    public void setNominalVoltage(int nominalVoltage) {
        this.nominalVoltage = nominalVoltage;
    }

    public int getMaximumNegativeDeviation() {
        return this.maximumNegativeDeviation;
    }

    public void setMaximumNegativeDeviation(int maximumNegativeDeviation) {
        this.maximumNegativeDeviation = maximumNegativeDeviation;
    }

    public int getMaximumPositiveDeviation() {
        return this.maximumPositiveDeviation;
    }

    public void setMaximumPositiveDeviation(int maximumPositiveDeviation) {
        this.maximumPositiveDeviation = maximumPositiveDeviation;
    }
}

