/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru.record;

import java.nio.charset.Charset;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public abstract class FruRecord {
    protected static String decodeString(int typeFormat, byte[] data, boolean isEnglishLanguageCode) {
        switch (typeFormat) {
            case 0: {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < data.length; ++i) {
                    int num = TypeConverter.byteToInt(data[i]);
                    if (num < 16) {
                        sb.append("0");
                    }
                    sb.append(Integer.toHexString(num));
                }
                return sb.toString();
            }
            case 1: {
                return TypeConverter.decodeBcdPlus(data);
            }
            case 2: {
                return TypeConverter.decode6bitAscii(data);
            }
            case 3: {
                System.arraycopy(data, 0, data, 0, data.length);
                if (isEnglishLanguageCode) {
                    return new String(data, Charset.forName("ISO-8859-1")).trim();
                }
                return new String(data, Charset.forName("UTF-8")).trim();
            }
        }
        throw new IllegalArgumentException("Invalid type format");
    }
}

