/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.fru.record;

import org.sentrysoftware.ipmi.core.coding.commands.fru.record.BaseCompatibilityInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.DcLoadInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.DcOutputInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ExtendedCompatibilityInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruMultiRecordType;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.FruRecord;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.ManagementAccessInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.OemInfo;
import org.sentrysoftware.ipmi.core.coding.commands.fru.record.PowerSupplyInfo;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public abstract class MultiRecordInfo
extends FruRecord {
    public static MultiRecordInfo populateMultiRecord(byte[] fruData, int offset) {
        MultiRecordInfo recordInfo = null;
        if ((TypeConverter.byteToInt(fruData[offset + 1]) & 0xF) != 2) {
            throw new IllegalArgumentException("Invalid FRU record version");
        }
        FruMultiRecordType recordType = FruMultiRecordType.parseInt(TypeConverter.byteToInt(fruData[offset]));
        int length = TypeConverter.byteToInt(fruData[offset + 2]);
        int currentOffset = offset + 5;
        switch (recordType) {
            case PowerSupplyInformation: {
                recordInfo = new PowerSupplyInfo(fruData, currentOffset);
                break;
            }
            case DcOutput: {
                recordInfo = new DcOutputInfo(fruData, currentOffset);
                break;
            }
            case DcLoad: {
                recordInfo = new DcLoadInfo(fruData, currentOffset);
                break;
            }
            case ManagementAccessRecord: {
                recordInfo = new ManagementAccessInfo(fruData, currentOffset, length);
                break;
            }
            case BaseCompatibilityRecord: {
                recordInfo = new BaseCompatibilityInfo(fruData, currentOffset, length);
                break;
            }
            case ExtendedCompatibilityRecord: {
                recordInfo = new ExtendedCompatibilityInfo(fruData, currentOffset, length);
                break;
            }
            case OemRecord: {
                recordInfo = new OemInfo(fruData, currentOffset, length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported record type");
            }
        }
        return recordInfo;
    }
}

