/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.payload;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.payload.ActivatePayloadResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.MessageComposer;
import org.sentrysoftware.ipmi.core.common.MessageReader;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public abstract class ActivatePayload
extends IpmiCommandCoder {
    private static final int REQUEST_DATA_LENGTH = 6;
    private static final int AUXILARY_DATA_LENGTH = 4;
    private static final int INBOUND_PAYLOAD_SIZE_LENGTH = 2;
    private static final int OUTBOUND_PAYLOAD_SIZE_LENGTH = 2;
    private static final int PAYLOAD_UDP_PORT_NUMBER_DATA_LENGTH = 2;
    private static final int PAYLOAD_VLAN_NUMBER_DATA_LENGTH = 2;
    private final int payloadInstance;

    public abstract PayloadType getPayloadType();

    protected ActivatePayload(IpmiVersion ipmiVersion, CipherSuite cipherSuite, AuthenticationType authenticationType, int payloadInstance) {
        super(ipmiVersion, cipherSuite, authenticationType);
        this.payloadInstance = payloadInstance;
    }

    @Override
    public byte getCommandCode() {
        return 72;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] message = MessageComposer.get(6).appendField(TypeConverter.intToByte(this.getPayloadType().getCode())).appendField(TypeConverter.intToByte(this.payloadInstance)).appendField(this.prepareAuxilaryRequestData()).getMessage();
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), message, TypeConverter.intToByte(sequenceNumber));
    }

    protected abstract byte[] prepareAuxilaryRequestData();

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Activate Payload command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        MessageReader messageReader = new MessageReader(message.getPayload().getData());
        ActivatePayloadResponseData responseData = this.createEmptyResponse();
        responseData.setAuxilaryInformationData(messageReader.readNextField(4));
        responseData.setInboundPayloadSize(messageReader.readNextField(2));
        responseData.setOutboundPayloadSize(messageReader.readNextField(2));
        responseData.setPayloadUdpPortNumber(messageReader.readNextField(2));
        responseData.setPayloadVlanNumber(messageReader.readNextField(2));
        return responseData;
    }

    protected abstract ActivatePayloadResponseData createEmptyResponse();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivatePayload that = (ActivatePayload)o;
        if (this.payloadInstance != that.payloadInstance) {
            return false;
        }
        if (this.getPayloadType() != that.getPayloadType()) {
            return false;
        }
        return this.getCipherSuite().equals(that.getCipherSuite());
    }

    public int hashCode() {
        int result = this.payloadInstance;
        result = 31 * result + this.getPayloadType().getCode();
        result = 31 * result + (this.getCipherSuite() != null ? this.getCipherSuite().hashCode() : 0);
        return result;
    }
}

