/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdrResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetSdr
extends IpmiCommandCoder {
    private int reservationId;
    private int recordId;
    private int offset;
    private int bytesToRead;

    public GetSdr(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int reservationId, int recordId) {
        this(version, cipherSuite, authenticationType, reservationId, recordId, 0, 255);
    }

    public GetSdr(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, int reservationId, int recordId, int offset, int bytesToRead) {
        super(version, cipherSuite, authenticationType);
        this.recordId = recordId;
        this.reservationId = reservationId;
        this.offset = offset;
        this.bytesToRead = bytesToRead;
    }

    @Override
    public byte getCommandCode() {
        return 35;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payload = new byte[6];
        byte[] buffer = TypeConverter.intToByteArray(this.reservationId);
        payload[0] = buffer[3];
        payload[1] = buffer[2];
        buffer = TypeConverter.intToByteArray(this.recordId);
        payload[2] = buffer[3];
        payload[3] = buffer[2];
        payload[4] = TypeConverter.intToByte(this.offset);
        payload[5] = TypeConverter.intToByte(this.bytesToRead);
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payload, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SDR command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length < 3) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetSdrResponseData responseData = new GetSdrResponseData();
        byte[] buffer = new byte[]{raw[0], raw[1], 0, 0};
        responseData.setNextRecordId(TypeConverter.littleEndianByteArrayToInt(buffer));
        byte[] recordData = new byte[raw.length - 2];
        System.arraycopy(raw, 2, recordData, 0, recordData.length);
        responseData.setSensorRecordData(recordData);
        return responseData;
    }
}

