/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr;

import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.SensorState;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.FullSensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.ReadingType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorType;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetSensorReadingResponseData
implements ResponseData {
    private byte sensorReading;
    private boolean sensorStateValid;
    private SensorState sensorState;
    private boolean[] statesAsserted;
    private byte[] raw;

    public double getSensorReading(FullSensorRecord sensorRecord) {
        return sensorRecord.calcFormula(TypeConverter.byteToInt(this.sensorReading));
    }

    public double getPlainSensorReading() {
        return TypeConverter.byteToInt(this.sensorReading);
    }

    public void setSensorReading(byte sensorReading) {
        this.sensorReading = sensorReading;
    }

    public boolean isSensorStateValid() {
        return this.sensorStateValid;
    }

    public void setSensorStateValid(boolean sensorStateValid) {
        this.sensorStateValid = sensorStateValid;
    }

    public SensorState getSensorState() {
        return this.sensorState;
    }

    public void setSensorState(SensorState sensorState) {
        this.sensorState = sensorState;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public List<ReadingType> getStatesAsserted(SensorType sensorType, int sensorEventReadingType) {
        ArrayList<ReadingType> list = new ArrayList<ReadingType>();
        for (int i = 0; i < this.statesAsserted.length; ++i) {
            if (!this.statesAsserted[i]) continue;
            list.add(ReadingType.parseInt(sensorType, sensorEventReadingType, i));
        }
        return list;
    }

    public void setStatesAsserted(boolean[] statesAsserted) {
        this.statesAsserted = statesAsserted;
    }
}

