/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr;

public enum SensorState {
    BelowLowerNonRecoverable(4),
    AboveUpperNonCritical(8),
    AboveUpperNonRecoverable(32),
    BelowLowerNonCritical(1),
    BelowLowerCritical(2),
    AboveUpperCritical(16),
    Ok(0),
    Invalid(-1);

    private static final int BELOWLOWERNONRECOVERABLE = 4;
    private static final int ABOVEUPPERNONCRITICAL = 8;
    private static final int ABOVEUPPERNONRECOVERABLE = 32;
    private static final int BELOWLOWERNONCRITICAL = 1;
    private static final int BELOWLOWERCRITICAL = 2;
    private static final int ABOVEUPPERCRITICAL = 16;
    private static final int OK = 0;
    private static final int INVALID = -1;
    private int code;

    private SensorState(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SensorState parseInt(int value) {
        if ((value & 4) != 0) {
            return BelowLowerNonRecoverable;
        }
        if ((value & 2) != 0) {
            return BelowLowerCritical;
        }
        if ((value & 8) != 0) {
            return BelowLowerNonCritical;
        }
        if ((value & 0x20) != 0) {
            return AboveUpperNonRecoverable;
        }
        if ((value & 0x10) != 0) {
            return AboveUpperCritical;
        }
        if ((value & 8) != 0) {
            return AboveUpperNonCritical;
        }
        if (value == 0) {
            return Ok;
        }
        return Invalid;
    }
}

