/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr.record;

import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.DeviceType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class FruDeviceLocatorRecord
extends SensorRecord {
    private int deviceAccessAddress;
    private int deviceId;
    private boolean logical;
    private int accessLun;
    private int managementChannelNumber;
    private DeviceType deviceType;
    private int deviceTypeModifier;
    private int fruEntityId;
    private int fruEntityInstance;
    private String name;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setDeviceAccessAddress((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1);
        this.setLogical((TypeConverter.byteToInt(recordData[7]) & 0x80) != 0);
        int deviceIdFromRecord = TypeConverter.byteToInt(recordData[6]);
        if (!this.isLogical()) {
            deviceIdFromRecord &= 0xFE;
            deviceIdFromRecord >>= 1;
        }
        this.setDeviceId(deviceIdFromRecord);
        int id = TypeConverter.byteToInt(recordData[6]);
        if (!this.isLogical()) {
            id >>= 1;
        }
        this.setId(id);
        this.setAccessLun((TypeConverter.byteToInt(recordData[7]) & 0xC) >> 2);
        this.setManagementChannelNumber((TypeConverter.byteToInt(recordData[8]) & 0xF0) >> 4);
        this.setDeviceType(DeviceType.parseInt(TypeConverter.byteToInt(recordData[10])));
        this.setDeviceTypeModifier(TypeConverter.byteToInt(recordData[11]));
        this.setFruEntityId(TypeConverter.byteToInt(recordData[12]));
        this.setFruEntityInstance(TypeConverter.byteToInt(recordData[13]));
        byte[] nameData = new byte[recordData.length - 16];
        System.arraycopy(recordData, 16, nameData, 0, nameData.length);
        this.setName(this.decodeName(recordData[15], nameData));
    }

    public int getDeviceAccessAddress() {
        return this.deviceAccessAddress;
    }

    public void setDeviceAccessAddress(int deviceAccessAddress) {
        this.deviceAccessAddress = deviceAccessAddress;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public boolean isLogical() {
        return this.logical;
    }

    public void setLogical(boolean logical) {
        this.logical = logical;
    }

    public int getAccessLun() {
        return this.accessLun;
    }

    public void setAccessLun(int accessLun) {
        this.accessLun = accessLun;
    }

    public int getManagementChannelNumber() {
        return this.managementChannelNumber;
    }

    public void setManagementChannelNumber(int managementChannelNumber) {
        this.managementChannelNumber = managementChannelNumber;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public int getDeviceTypeModifier() {
        return this.deviceTypeModifier;
    }

    public void setDeviceTypeModifier(int deviceTypeModifier) {
        this.deviceTypeModifier = deviceTypeModifier;
    }

    public int getFruEntityId() {
        return this.fruEntityId;
    }

    public void setFruEntityId(int fruEntityId) {
        this.fruEntityId = fruEntityId;
    }

    public int getFruEntityInstance() {
        return this.fruEntityInstance;
    }

    public void setFruEntityInstance(int fruEntityInstance) {
        this.fruEntityInstance = fruEntityInstance;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

