/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr.record;

import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class ManagementControllerConfirmationRecord
extends SensorRecord {
    private int deviceSlaveAddress;
    private int deviceId;
    private int channelNumber;
    private int deviceRevision;
    private int firmwareRevision1;
    private int firmwareRevision2;
    private int ipmiVersion;
    private int manufacturerId;
    private int productId;
    private byte[] deviceGuid;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setDeviceSlaveAddress(TypeConverter.byteToInt(recordData[5]) >> 1);
        this.setDeviceId(TypeConverter.byteToInt(recordData[6]));
        this.setChannelNumber((TypeConverter.byteToInt(recordData[7]) & 0xF0) >> 4);
        this.setDeviceRevision(TypeConverter.byteToInt(recordData[7]) & 0xF);
        this.setFirmwareRevision1(TypeConverter.byteToInt(recordData[8]) & 0x7F);
        this.setFirmwareRevision2(TypeConverter.littleEndianBcdByteToInt(recordData[9]));
        this.setIpmiVersion(TypeConverter.littleEndianBcdByteToInt(recordData[10]));
        byte[] buffer = new byte[4];
        System.arraycopy(recordData, 11, buffer, 0, 3);
        buffer[3] = 0;
        this.setManufacturerId(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(recordData, 14, buffer, 0, 2);
        buffer[2] = 0;
        buffer[3] = 0;
        this.setProductId(TypeConverter.littleEndianByteArrayToInt(buffer));
        byte[] guid = new byte[16];
        System.arraycopy(recordData, 16, guid, 0, 16);
        this.setDeviceGuid(guid);
    }

    public int getDeviceSlaveAddress() {
        return this.deviceSlaveAddress;
    }

    public void setDeviceSlaveAddress(int deviceSlaveAddress) {
        this.deviceSlaveAddress = deviceSlaveAddress;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(int channelNumber) {
        this.channelNumber = channelNumber;
    }

    public int getDeviceRevision() {
        return this.deviceRevision;
    }

    public void setDeviceRevision(int deviceRevision) {
        this.deviceRevision = deviceRevision;
    }

    public int getFirmwareRevision1() {
        return this.firmwareRevision1;
    }

    public void setFirmwareRevision1(int firmwareRevision1) {
        this.firmwareRevision1 = firmwareRevision1;
    }

    public int getFirmwareRevision2() {
        return this.firmwareRevision2;
    }

    public void setFirmwareRevision2(int firmwareRevision2) {
        this.firmwareRevision2 = firmwareRevision2;
    }

    public int getIpmiVersion() {
        return this.ipmiVersion;
    }

    public void setIpmiVersion(int ipmiVersion) {
        this.ipmiVersion = ipmiVersion;
    }

    public int getManufacturerId() {
        return this.manufacturerId;
    }

    public void setManufacturerId(int manufacturerId) {
        this.manufacturerId = manufacturerId;
    }

    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    public byte[] getDeviceGuid() {
        return this.deviceGuid;
    }

    public void setDeviceGuid(byte[] deviceGuid) {
        this.deviceGuid = deviceGuid;
    }
}

