/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.payload;

public enum CompletionCode {
    Ok(0),
    InsufficientResources(1),
    UnauthorizedRole(10),
    InsufficientResourcesForRole(11),
    InvalidNameLength(12),
    Frudevicebusy(129),
    UnauthorizedName(13),
    InvalidSessionId(135),
    InvalidSessionHandle(136),
    UnauthorizedGuid(14),
    InvalidIntegrityCheckValue(15),
    InvalidConfidentialityAlgorithm(16),
    NoMatchingCipherSuite(17),
    IllegalOrUnrecognizedParameter(18),
    NodeBusy(192),
    InvalidCommand(193),
    InvalidLun(194),
    Timeout(195),
    OutOfSpace(196),
    ReservationCanceled(197),
    RequestTruncated(198),
    InvalidRequestLength(199),
    InvalidId(2),
    LengthLimitExceeded(200),
    ParameterOutOfRange(201),
    CannotRespond(202),
    DataNotPresent(203),
    InvalidData(204),
    IllegalCommand(205),
    ResponseUnavailable(206),
    DuplicatedRequest(207),
    SdrUpdating(208),
    FirmwareUpdating(209),
    InitializationInProgress(210),
    DestinationUnavailable(211),
    InsufficentPrivilege(212),
    CommandNotSupported(213),
    IllegalParameter(214),
    UnspecifiedError(255),
    InvalidPayloadType(3),
    InvalidAuthenticationAlgorithm(4),
    InvalidIntegrityAlgorithm(5),
    NoMatchingAuthenticationPayload(6),
    NoMatchingIntegrityPayload(7),
    InactiveSessionID(8),
    InvalidRole(9);

    private static final int OK = 0;
    private static final int INSUFFICIENTRESOURCES = 1;
    private static final int UNAUTHORIZEDROLE = 10;
    private static final int INSUFFICIENTRESOURCESFORROLE = 11;
    private static final int INVALIDNAMELENGTH = 12;
    private static final int FRUDEVICEBUSY = 129;
    private static final int UNAUTHORIZEDNAME = 13;
    private static final int INVALIDSESSIONID = 135;
    private static final int INVALIDSESSIONHANDLE = 136;
    private static final int UNAUTHORIZEDGUID = 14;
    private static final int INVALIDINTEGRITYCHECKVALUE = 15;
    private static final int INVALIDCONFIDENTIALITYALGORITHM = 16;
    private static final int NOMATCHINGCIPHERSUITE = 17;
    private static final int ILLEGALORUNRECOGNIZEDPARAMETER = 18;
    private static final int NODEBUSY = 192;
    private static final int INVALIDCOMMAND = 193;
    private static final int INVALIDLUN = 194;
    private static final int TIMEOUT = 195;
    private static final int OUTOFSPACE = 196;
    private static final int RESERVATIONCANCELED = 197;
    private static final int REQUESTTRUNCATED = 198;
    private static final int INVALIDREQUESTLENGTH = 199;
    private static final int INVALIDID = 2;
    private static final int LENGTHLIMITEXCEEDED = 200;
    private static final int PARAMETEROUTOFRANGE = 201;
    private static final int CANNOTRESPOND = 202;
    private static final int DATANOTPRESENT = 203;
    private static final int INVALIDDATA = 204;
    private static final int ILLEGALCOMMAND = 205;
    private static final int RESPONSEUNAVAILABLE = 206;
    private static final int DUPLICATEDREQUEST = 207;
    private static final int SDRUPDATING = 208;
    private static final int FIRMWAREUPDATING = 209;
    private static final int INITIALIZATIONINPROGRESS = 210;
    private static final int DESTINATIONUNAVAILABLE = 211;
    private static final int INSUFFICENTPRIVILEGE = 212;
    private static final int COMMANDNOTSUPPORTED = 213;
    private static final int ILLEGALPARAMETER = 214;
    private static final int UNSPECIFIEDERROR = 255;
    private static final int INVALIDPAYLOADTYPE = 3;
    private static final int INVALIDAUTHENTICATIONALGORITHM = 4;
    private static final int INVALIDINTEGRITYALGORITHM = 5;
    private static final int NOMATCHINGAUTHENTICATIONPAYLOAD = 6;
    private static final int NOMATCHINGINTEGRITYPAYLOAD = 7;
    private static final int INACTIVESESSIONID = 8;
    private static final int INVALIDROLE = 9;
    private int code;

    private CompletionCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CompletionCode parseInt(int value) {
        switch (value) {
            case 0: {
                return Ok;
            }
            case 1: {
                return InsufficientResources;
            }
            case 10: {
                return UnauthorizedRole;
            }
            case 11: {
                return InsufficientResourcesForRole;
            }
            case 12: {
                return InvalidNameLength;
            }
            case 129: {
                return Frudevicebusy;
            }
            case 13: {
                return UnauthorizedName;
            }
            case 135: {
                return InvalidSessionId;
            }
            case 136: {
                return InvalidSessionHandle;
            }
            case 14: {
                return UnauthorizedGuid;
            }
            case 15: {
                return InvalidIntegrityCheckValue;
            }
            case 16: {
                return InvalidConfidentialityAlgorithm;
            }
            case 17: {
                return NoMatchingCipherSuite;
            }
            case 18: {
                return IllegalOrUnrecognizedParameter;
            }
            case 192: {
                return NodeBusy;
            }
            case 193: {
                return InvalidCommand;
            }
            case 194: {
                return InvalidLun;
            }
            case 195: {
                return Timeout;
            }
            case 196: {
                return OutOfSpace;
            }
            case 197: {
                return ReservationCanceled;
            }
            case 198: {
                return RequestTruncated;
            }
            case 199: {
                return InvalidRequestLength;
            }
            case 2: {
                return InvalidId;
            }
            case 200: {
                return LengthLimitExceeded;
            }
            case 201: {
                return ParameterOutOfRange;
            }
            case 202: {
                return CannotRespond;
            }
            case 203: {
                return DataNotPresent;
            }
            case 204: {
                return InvalidData;
            }
            case 205: {
                return IllegalCommand;
            }
            case 206: {
                return ResponseUnavailable;
            }
            case 207: {
                return DuplicatedRequest;
            }
            case 208: {
                return SdrUpdating;
            }
            case 209: {
                return FirmwareUpdating;
            }
            case 210: {
                return InitializationInProgress;
            }
            case 211: {
                return DestinationUnavailable;
            }
            case 212: {
                return InsufficentPrivilege;
            }
            case 213: {
                return CommandNotSupported;
            }
            case 214: {
                return IllegalParameter;
            }
            case 255: {
                return UnspecifiedError;
            }
            case 3: {
                return InvalidPayloadType;
            }
            case 4: {
                return InvalidAuthenticationAlgorithm;
            }
            case 5: {
                return InvalidIntegrityAlgorithm;
            }
            case 6: {
                return NoMatchingAuthenticationPayload;
            }
            case 7: {
                return NoMatchingIntegrityPayload;
            }
            case 8: {
                return InactiveSessionID;
            }
            case 9: {
                return InvalidRole;
            }
        }
        throw new IllegalArgumentException("Invalid value: " + value);
    }

    public String getMessage() {
        switch (this.code) {
            case 0: {
                return "Command completed normally.";
            }
            case 1: {
                return "Insufficient resources to create a session.";
            }
            case 10: {
                return "Unauthorized role or privilege level requested.";
            }
            case 11: {
                return "Insufficient resources to create a session at the requested role.";
            }
            case 12: {
                return "Invalid name length.";
            }
            case 129: {
                return "FRU device busy. The requested cannot be completed because the implementation of the logical FRU device is in a state where the FRU information is temporarily unavailable. This could be due to a condition such as a los s of arbitration if the FRU is implemented as a device on a shared bus.";
            }
            case 13: {
                return "Unauthorized name.";
            }
            case 135: {
                return "Invalid Session ID in request.";
            }
            case 136: {
                return "Invalid Session Handle in request.";
            }
            case 14: {
                return "GUID that BMC submitted in RAKP Message 2 was not accepted by remote console.";
            }
            case 15: {
                return "Invalid integrity check value.";
            }
            case 16: {
                return "Invalid confidentiality algorithm.";
            }
            case 17: {
                return "No Cipher Suite match with proposed security algorithms.";
            }
            case 18: {
                return "Illegal or unrecognized parameter.";
            }
            case 192: {
                return "Command could not be processed because command processing resources are temporarily unavailable.";
            }
            case 193: {
                return "Used to indicate an unrecognized or unsupported command.";
            }
            case 194: {
                return "Command invalid for given LUN.";
            }
            case 195: {
                return "Timeout while processing command. Response unavailable.";
            }
            case 196: {
                return "Out of space. Command could not be completed because of a lack of storage space required to execute the given command operation.";
            }
            case 197: {
                return "Reservation Canceled or Invalid Reservation ID.";
            }
            case 198: {
                return "Request data truncated.";
            }
            case 199: {
                return "Request data length invalid.";
            }
            case 2: {
                return "Invalid session ID.";
            }
            case 200: {
                return "Request data field length limit exceeded.";
            }
            case 201: {
                return "Parameter out of range. One or more parameters in the data field of the Request are out of range. This is different from {@link #InvalidData} (CCh) code in that it indicates that the erroneous field(s) has a contiguous range of possible values.";
            }
            case 202: {
                return "Cannot return number of requested data bytes.";
            }
            case 203: {
                return "Requested Sensor, data, or record not present.";
            }
            case 204: {
                return "Invalid data field in Request.";
            }
            case 205: {
                return "Command illegal for specified sensor or record type.";
            }
            case 206: {
                return "Command response could not be provided.";
            }
            case 207: {
                return "Cannot execute duplicated request. This completion code is for devices which cannot return the response that was returned for the original instance of the request. Such devices should provide separate commands that allow the completion status of the original request to be determined. An Event Receiver does not use this completion code, but returns the 00h completion code in the response to (valid) duplicated requests.";
            }
            case 208: {
                return "Command response could not be provided. SDR Repository in update mode.";
            }
            case 209: {
                return "Command response could not be provided. Device in firmware update mode.";
            }
            case 210: {
                return "Command response could not be provided. BMC initialization or initialization agent in progress.";
            }
            case 211: {
                return "Destination unavailable. Cannot deliver request to selected destination. E.g. this code can be returned if a request message is targeted to SMS, but receive message queue reception is disabled for the particular channel.";
            }
            case 212: {
                return "Cannot execute command due to insufficient privilege level or other security - based restriction (e.g. disabled for 'firmware firewall').";
            }
            case 213: {
                return "Cannot execute command. Command, or request parameter(s), not supported in present state.";
            }
            case 214: {
                return "Cannot execute command. Parameter is illegal because command sub-function has been disabled or is unavailable (e.g. disabled for 'firmware firewall').";
            }
            case 255: {
                return "Unspecified error.";
            }
            case 3: {
                return "Invalid payload type.";
            }
            case 4: {
                return "Invalid authentication algorithm.";
            }
            case 5: {
                return "Invalid integrity algorithm.";
            }
            case 6: {
                return "No matching authentication payload.";
            }
            case 7: {
                return "No matching integrity payload.";
            }
            case 8: {
                return "Inactive session ID.";
            }
            case 9: {
                return "Invalid role.";
            }
        }
        throw new IllegalArgumentException("Invalid value: " + this.code);
    }
}

