/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.payload.lan;

import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public abstract class IpmiLanMessage
extends IpmiPayload {
    public static final int MIN_SEQUENCE_NUMBER = 1;
    public static final int MAX_SEQUENCE_NUMBER = 63;
    private byte responderAddress;
    protected byte networkFunction;
    private byte responderLogicalUnitNumber;
    private byte requesterAddress;
    private byte requesterLogicalUnitNumber;
    private byte sequenceNumber;
    private byte command;

    public void setResponderAddress(byte responderAddress) {
        this.responderAddress = responderAddress;
    }

    public byte getResponderAddress() {
        return this.responderAddress;
    }

    public void setNetworkFunction(NetworkFunction networkFunction) {
        this.networkFunction = TypeConverter.intToByte(networkFunction.getCode());
    }

    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.parseInt(TypeConverter.byteToInt(this.networkFunction));
    }

    public void setResponderLogicalUnitNumber(byte responderLogicalUnitNumber) {
        this.responderLogicalUnitNumber = responderLogicalUnitNumber;
    }

    public byte getResponderLogicalUnitNumber() {
        return this.responderLogicalUnitNumber;
    }

    public void setSequenceNumber(byte sequenceAddress) {
        this.sequenceNumber = sequenceAddress;
    }

    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setRequesterAddress(byte requesterAddress) {
        this.requesterAddress = requesterAddress;
    }

    public byte getRequesterAddress() {
        return this.requesterAddress;
    }

    public void setRequesterLogicalUnitNumber(byte requesterLogicalUnitNumber) {
        this.requesterLogicalUnitNumber = requesterLogicalUnitNumber;
    }

    public byte getRequesterLogicalUnitNumber() {
        return this.requesterLogicalUnitNumber;
    }

    public void setCommand(byte command) {
        this.command = command;
    }

    public byte getCommand() {
        return this.command;
    }

    @Override
    public abstract int getPayloadLength();

    @Override
    public abstract byte[] getPayloadData();

    protected byte getChecksum1(byte[] message) {
        int checksum = 0;
        for (int i = 0; i < 2; ++i) {
            checksum = (checksum + TypeConverter.byteToInt(message[i])) % 256;
        }
        return -TypeConverter.intToByte(checksum);
    }

    protected byte getChecksum2(byte[] message) {
        int checksum = 0;
        for (int i = 3; i < message.length - 1; ++i) {
            checksum = (checksum + TypeConverter.byteToInt(message[i])) % 256;
        }
        return -TypeConverter.intToByte(checksum);
    }

    @Override
    public byte[] getIpmiCommandData() {
        return this.getData();
    }
}

