/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.payload.sol;

import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.common.MessageComposer;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public abstract class SolMessage
extends IpmiPayload {
    public static final byte MIN_SEQUENCE_NUMBER = 1;
    public static final byte MAX_SEQUENCE_NUMBER = 15;
    private static final int PACKET_SEQUENCE_NUMBER_LENGTH = 1;
    private static final int PACKET_ACK_SEQUENCE_NUMBER_LENGTH = 1;
    private static final int ACCEPTED_CHARACTERS_LENGTH = 1;
    private static final int OPERATION_STATUS_LENGTH = 1;
    public static final int PAYLOAD_HEADER_LENGTH = 4;
    private final byte sequenceNumber;
    private final byte ackNackSequenceNumber;
    private final byte acceptedCharacterCount;
    private final byte operationStatus;

    protected SolMessage(byte sequenceNumber, byte ackNackSequenceNumber, byte acceptedCharacterCount, byte operationStatus) {
        this.sequenceNumber = this.trimSequenceNumber(sequenceNumber);
        this.ackNackSequenceNumber = this.trimSequenceNumber(ackNackSequenceNumber);
        this.acceptedCharacterCount = acceptedCharacterCount;
        this.operationStatus = operationStatus;
    }

    private byte trimSequenceNumber(byte sequenceNumber) {
        return TypeConverter.intToByte(sequenceNumber & 0xF);
    }

    @Override
    public byte[] getPayloadData() {
        return MessageComposer.get(this.getPayloadLength()).appendField(this.sequenceNumber).appendField(this.ackNackSequenceNumber).appendField(this.acceptedCharacterCount).appendField(this.operationStatus).appendField(this.getData()).getMessage();
    }

    @Override
    public int getPayloadLength() {
        return 4 + this.getData().length;
    }

    @Override
    public byte[] getIpmiCommandData() {
        return this.getData();
    }

    @Override
    public byte[] getData() {
        byte[] data = super.getData();
        if (data == null) {
            return new byte[0];
        }
        return data;
    }

    public byte getSequenceNumber() {
        return this.sequenceNumber;
    }

    public byte getAckNackSequenceNumber() {
        return this.ackNackSequenceNumber;
    }

    public byte getAcceptedCharacterCount() {
        return this.acceptedCharacterCount;
    }

    public boolean isDataCarrier() {
        return this.sequenceNumber != 0 || this.getData().length > 0;
    }

    public boolean isAcknowledgeMessage() {
        return this.ackNackSequenceNumber != 0;
    }
}

