/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.payload.sol;

import java.util.HashSet;
import java.util.Set;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolAckState;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolOperation;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class SolOutboundOperationField {
    private final SolAckState ackState;
    private final Set<SolOperation> operations;

    public SolOutboundOperationField(SolAckState ackState, Set<SolOperation> operations) {
        this.ackState = ackState;
        this.operations = operations;
    }

    public SolOutboundOperationField(byte raw) {
        this.ackState = SolAckState.extractFromByte(raw);
        this.operations = this.extractOperationsFromByte(raw);
    }

    protected Set<SolOperation> extractOperationsFromByte(byte raw) {
        HashSet<SolOperation> result = new HashSet<SolOperation>();
        for (SolOperation operation : SolOperation.values()) {
            if (!TypeConverter.isBitSetOnPosition(operation.getOperationNumber(), raw)) continue;
            result.add(operation);
        }
        return result;
    }

    public Set<SolOperation> getOperations() {
        return this.operations;
    }

    public SolAckState getAckState() {
        return this.ackState;
    }

    public byte convertToByte() {
        byte value = 0;
        value = this.ackState.encodeInByte(value);
        for (SolOperation operation : this.operations) {
            value = TypeConverter.setBitOnPosition(operation.getOperationNumber(), value);
        }
        return value;
    }
}

