/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.protocol.decoder;

import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolInboundMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.IpmiDecoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpClassOfMessage;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.security.ConfidentialityAlgorithm;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public abstract class ProtocolDecoder
implements IpmiDecoder {
    @Deprecated
    protected int decode(RmcpMessage rmcpMessage, IpmiMessage message, int sequenceNumberOffset, int payloadLengthOffset, int payloadLengthLength) {
        if (rmcpMessage.getClassOfMessage() != RmcpClassOfMessage.Ipmi) {
            throw new IllegalArgumentException("This is not an IPMI message");
        }
        byte[] raw = rmcpMessage.getData();
        message.setAuthenticationType(ProtocolDecoder.decodeAuthenticationType(raw[0]));
        message.setSessionSequenceNumber(this.decodeSessionSequenceNumber(raw, sequenceNumberOffset));
        message.setPayloadLength(this.decodePayloadLength(raw, payloadLengthOffset));
        message.setPayload(this.decodePayload(raw, payloadLengthOffset + payloadLengthLength, message.getPayloadLength(), message.getConfidentialityAlgorithm(), PayloadType.Ipmi));
        return payloadLengthOffset + payloadLengthLength + message.getPayloadLength();
    }

    protected static AuthenticationType decodeAuthenticationType(byte authenticationType) {
        authenticationType = (byte)(authenticationType & TypeConverter.intToByte(15));
        return AuthenticationType.parseInt(TypeConverter.byteToInt(authenticationType));
    }

    public static AuthenticationType decodeAuthenticationType(RmcpMessage message) {
        return ProtocolDecoder.decodeAuthenticationType(message.getData()[0]);
    }

    protected static int decodeInt(byte[] rawMessage, int offset) {
        byte[] result = new byte[4];
        System.arraycopy(rawMessage, offset, result, 0, 4);
        return TypeConverter.littleEndianByteArrayToInt(result);
    }

    protected int decodeSessionSequenceNumber(byte[] rawMessage, int offset) {
        return ProtocolDecoder.decodeInt(rawMessage, offset);
    }

    protected static int decodeSessionID(byte[] rawMessage, int offset) {
        return ProtocolDecoder.decodeInt(rawMessage, offset);
    }

    protected abstract int decodePayloadLength(byte[] var1, int var2);

    protected IpmiPayload decodePayload(byte[] rawData, int offset, int length, ConfidentialityAlgorithm confidentialityAlgorithm, PayloadType payloadType) {
        byte[] payload = null;
        if (length > 0) {
            payload = new byte[length];
            System.arraycopy(rawData, offset, payload, 0, length);
            payload = confidentialityAlgorithm.decrypt(payload);
        }
        if (payloadType == PayloadType.Sol) {
            return new SolInboundMessage(payload);
        }
        return new IpmiLanResponse(payload);
    }
}

