/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.protocol.encoder;

import java.security.InvalidKeyException;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv15Message;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.ProtocolEncoder;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class Protocolv15Encoder
extends ProtocolEncoder {
    @Override
    public byte[] encode(IpmiMessage ipmiMessage) throws InvalidKeyException {
        byte[] payload;
        if (!(ipmiMessage instanceof Ipmiv15Message)) {
            throw new IllegalArgumentException("IPMIMessage must be in 1.5 version.");
        }
        Ipmiv15Message message = (Ipmiv15Message)ipmiMessage;
        byte[] raw = new byte[this.getMessageLength(message)];
        raw[0] = this.encodeAuthenticationType(message.getAuthenticationType());
        int offset = 1;
        this.encodeSessionSequenceNumber(message.getSessionSequenceNumber(), raw, offset);
        this.encodeSessionId(message.getSessionID(), raw, offset += 4);
        offset += 4;
        if (message.getAuthenticationType() != AuthenticationType.None) {
            this.encodeAuthenticationCode(message.getAuthCode(), raw, offset);
            offset += message.getAuthCode().length;
        }
        if ((payload = message.getPayload().getEncryptedPayload()) == null) {
            message.getPayload().encryptPayload(message.getConfidentialityAlgorithm());
            payload = message.getPayload().getEncryptedPayload();
        }
        this.encodePayloadLength(payload.length, raw, offset);
        ++offset;
        offset = this.encodePayload(payload, raw, offset);
        this.encodeSessionTrailer(raw, offset);
        return raw;
    }

    private int getMessageLength(IpmiMessage ipmiMessage) {
        int length = 11 + ipmiMessage.getConfidentialityAlgorithm().getConfidentialityOverheadSize(ipmiMessage.getPayloadLength()) + ipmiMessage.getPayloadLength();
        if (ipmiMessage.getAuthenticationType() != AuthenticationType.None) {
            length += 16;
        }
        return length;
    }

    private void encodeAuthenticationCode(byte[] authCode, byte[] message, int offset) {
        if (authCode.length + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        System.arraycopy(authCode, 0, message, offset, authCode.length);
    }

    @Override
    protected void encodePayloadLength(int value, byte[] message, int offset) {
        message[offset] = TypeConverter.intToByte(value);
    }

    private int encodeSessionTrailer(byte[] message, int offset) {
        if (1 + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        message[offset] = 0;
        return offset + 1;
    }
}

