/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.protocol.encoder;

import java.security.InvalidKeyException;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv20Message;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.ProtocolEncoder;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class Protocolv20Encoder
extends ProtocolEncoder {
    @Override
    public byte[] encode(IpmiMessage ipmiMessage) throws InvalidKeyException {
        if (!(ipmiMessage instanceof Ipmiv20Message)) {
            throw new IllegalArgumentException("IPMIMessage must be in 2.0 version.");
        }
        Ipmiv20Message message = (Ipmiv20Message)ipmiMessage;
        byte[] payload = message.getPayload().getEncryptedPayload();
        if (payload == null) {
            message.getPayload().encryptPayload(message.getConfidentialityAlgorithm());
            payload = message.getPayload().getEncryptedPayload();
        }
        byte[] raw = new byte[this.getMessageLength(message)];
        if (message.getAuthenticationType() != AuthenticationType.RMCPPlus) {
            throw new IllegalArgumentException("Authentication type must be RMCP+ for IPMI v2.0");
        }
        raw[0] = this.encodeAuthenticationType(message.getAuthenticationType());
        int offset = 1;
        raw[offset] = this.encodePayloadType(message.isPayloadEncrypted(), message.isPayloadAuthenticated(), message.getPayloadType());
        ++offset;
        if (message.getPayloadType() == PayloadType.Oem) {
            this.encodeOEMIANA(message.getOemIANA(), raw, offset);
            this.encodeOEMPayloadId(message.getOemPayloadID(), raw, offset += 4);
            offset += 2;
        }
        this.encodeSessionId(message.getSessionID(), raw, offset);
        this.encodeSessionSequenceNumber(message.getSessionSequenceNumber(), raw, offset += 4);
        this.encodePayloadLength(payload.length, raw, offset += 4);
        offset += 2;
        offset = this.encodePayload(payload, raw, offset);
        if (message.isPayloadAuthenticated() && message.getSessionID() != 0) {
            this.encodeSessionTrailer(message.getAuthCode(), raw, offset);
        }
        return raw;
    }

    private int getMessageLength(Ipmiv20Message ipmiMessage) {
        int length = 12 + ipmiMessage.getConfidentialityAlgorithm().getConfidentialityOverheadSize(ipmiMessage.getPayloadLength()) + ipmiMessage.getPayloadLength();
        if (ipmiMessage.getPayloadType() == PayloadType.Oem) {
            length += 6;
        }
        if (ipmiMessage.isPayloadAuthenticated() && ipmiMessage.getSessionID() != 0) {
            if (ipmiMessage.getAuthCode() != null) {
                if ((length + ipmiMessage.getAuthCode().length + 2) % 4 != 0) {
                    length += 4 - (length + ipmiMessage.getAuthCode().length + 2) % 4;
                }
                length += ipmiMessage.getAuthCode().length;
            }
            length += 2;
        }
        return length;
    }

    private byte encodePayloadType(boolean isEncrypted, boolean isAuthenticated, PayloadType payloadType) {
        byte result = 0;
        if (isEncrypted) {
            result = (byte)(result | TypeConverter.intToByte(128));
        }
        if (isAuthenticated) {
            result = (byte)(result | TypeConverter.intToByte(64));
        }
        result = (byte)(result | TypeConverter.intToByte(payloadType.getCode()));
        return result;
    }

    private void encodeOEMIANA(int value, byte[] message, int offset) {
        this.encodeInt(value, message, offset);
    }

    protected void encodeOEMPayloadId(Object value, byte[] message, int offset) {
        byte[] oemId = null;
        try {
            oemId = (byte[])value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value is corrupted", e);
        }
        if (oemId.length != 2) {
            throw new IllegalArgumentException("Value has invalid length");
        }
        if (oemId.length + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        System.arraycopy(oemId, 0, message, offset, 2);
    }

    @Override
    protected void encodePayloadLength(int value, byte[] message, int offset) {
        byte[] payloadLength = TypeConverter.intToLittleEndianByteArray(value);
        message[offset] = payloadLength[0];
        message[offset + 1] = payloadLength[1];
    }

    private int encodeSessionTrailer(byte[] authCode, byte[] message, int offset) {
        int pad = 0;
        if (authCode != null && authCode.length + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        if (authCode != null) {
            pad = (offset + authCode.length + 2) % 4;
        }
        pad = pad > 0 ? 4 - pad : 0;
        int currentOffset = offset;
        for (int i = 0; i < pad; ++i) {
            message[currentOffset] = TypeConverter.intToByte(255);
            ++currentOffset;
        }
        message[currentOffset] = TypeConverter.intToByte(pad);
        message[++currentOffset] = TypeConverter.intToByte(7);
        ++currentOffset;
        if (authCode != null) {
            System.arraycopy(authCode, 0, message, currentOffset, authCode.length);
            currentOffset += authCode.length;
        }
        return currentOffset;
    }
}

