/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.rmcp;

import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpClassOfMessage;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpVersion;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class RmcpPingMessage
extends RmcpMessage {
    public RmcpPingMessage(int sequenceNumber) {
        if (sequenceNumber > 254 || sequenceNumber < 0) {
            throw new IllegalArgumentException("Sequence number must be in range 0-254");
        }
        this.setVersion(RmcpVersion.RMCP1_0);
        this.setClassOfMessage(RmcpClassOfMessage.Asf);
        this.setData(this.preparePingMessage(sequenceNumber));
    }

    private byte[] preparePingMessage(int sequenceNumber) {
        byte[] message = new byte[8];
        System.arraycopy(TypeConverter.intToByteArray(4542), 0, message, 0, 4);
        message[4] = -128;
        message[5] = TypeConverter.intToByte(sequenceNumber);
        message[6] = 0;
        message[7] = 0;
        return message;
    }
}

