/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.NoSuchPaddingException;
import org.sentrysoftware.ipmi.core.coding.security.AuthenticationAlgorithm;
import org.sentrysoftware.ipmi.core.coding.security.AuthenticationRakpHmacSha1;
import org.sentrysoftware.ipmi.core.coding.security.AuthenticationRakpNone;
import org.sentrysoftware.ipmi.core.coding.security.ConfidentialityAesCbc128;
import org.sentrysoftware.ipmi.core.coding.security.ConfidentialityAlgorithm;
import org.sentrysoftware.ipmi.core.coding.security.ConfidentialityNone;
import org.sentrysoftware.ipmi.core.coding.security.IntegrityAlgorithm;
import org.sentrysoftware.ipmi.core.coding.security.IntegrityHmacSha1_96;
import org.sentrysoftware.ipmi.core.coding.security.IntegrityNone;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class CipherSuite {
    public static final String NOT_YET_IMPLEMENTED_MESSAGE = "Not yet implemented.";
    private byte id;
    private byte authenticationAlgorithm;
    private byte integrityAlgorithm;
    private byte confidentialityAlgorithm;
    private AuthenticationAlgorithm aa;
    private ConfidentialityAlgorithm ca;
    private IntegrityAlgorithm ia;

    public byte getId() {
        return this.id;
    }

    public CipherSuite(byte id, byte authenticationAlgorithm, byte confidentialityAlgorithm, byte integrityAlgorithm) {
        this.id = id;
        this.authenticationAlgorithm = authenticationAlgorithm;
        this.confidentialityAlgorithm = confidentialityAlgorithm;
        this.integrityAlgorithm = integrityAlgorithm;
    }

    public void initializeAlgorithms(byte[] sik) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.getIntegrityAlgorithm().initialize(sik);
        this.getConfidentialityAlgorithm().initialize(sik);
    }

    public AuthenticationAlgorithm getAuthenticationAlgorithm() {
        if (this.aa != null && this.aa.getCode() != this.authenticationAlgorithm) {
            throw new IllegalArgumentException("Invalid authentication algorithm code");
        }
        switch (this.authenticationAlgorithm) {
            case 0: {
                if (this.aa == null) {
                    this.aa = new AuthenticationRakpNone();
                }
                return this.aa;
            }
            case 1: {
                if (this.aa == null) {
                    try {
                        this.aa = new AuthenticationRakpHmacSha1();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalArgumentException("Initiation of the algorithm failed", e);
                    }
                }
                return this.aa;
            }
            case 2: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
            case 3: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
        }
        throw new IllegalArgumentException("Invalid authentication algorithm.");
    }

    public IntegrityAlgorithm getIntegrityAlgorithm() {
        if (this.ia != null && this.ia.getCode() != this.integrityAlgorithm) {
            throw new IllegalArgumentException("Invalid integrity algorithm code");
        }
        switch (this.integrityAlgorithm) {
            case 0: {
                if (this.ia == null) {
                    this.ia = new IntegrityNone();
                }
                return this.ia;
            }
            case 1: {
                if (this.ia == null) {
                    try {
                        this.ia = new IntegrityHmacSha1_96();
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IllegalArgumentException("Initiation of the algorithm failed", e);
                    }
                }
                return this.ia;
            }
            case 4: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
            case 3: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
            case 2: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
        }
        throw new IllegalArgumentException("Invalid integrity algorithm.");
    }

    public ConfidentialityAlgorithm getConfidentialityAlgorithm() {
        if (this.ca != null && this.ca.getCode() != this.confidentialityAlgorithm) {
            throw new IllegalArgumentException("Invalid confidentiality algorithm code");
        }
        switch (this.confidentialityAlgorithm) {
            case 0: {
                if (this.ca == null) {
                    this.ca = new ConfidentialityNone();
                }
                return this.ca;
            }
            case 1: {
                if (this.ca == null) {
                    this.ca = new ConfidentialityAesCbc128();
                }
                return this.ca;
            }
            case 3: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
            case 2: {
                throw new IllegalArgumentException(NOT_YET_IMPLEMENTED_MESSAGE);
            }
        }
        throw new IllegalArgumentException("Invalid confidentiality algorithm.");
    }

    public static List<CipherSuite> getCipherSuites(byte[] bytes) {
        ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>();
        int offset = 0;
        while (offset < bytes.length) {
            byte id = bytes[offset + 1];
            offset = bytes[offset] == TypeConverter.intToByte(192) ? (offset += 2) : (offset += 5);
            byte aa = bytes[offset];
            byte ca = -1;
            byte ia = -1;
            ++offset;
            while (offset < bytes.length && bytes[offset] != TypeConverter.intToByte(192) && bytes[offset] != TypeConverter.intToByte(193)) {
                if ((TypeConverter.byteToInt(bytes[offset]) & 0xC0) == 128) {
                    ca = TypeConverter.intToByte(TypeConverter.byteToInt(bytes[offset]) & 0x3F);
                } else if ((TypeConverter.byteToInt(bytes[offset]) & 0xC0) == 64) {
                    ia = TypeConverter.intToByte(TypeConverter.byteToInt(bytes[offset]) & 0x3F);
                }
                ++offset;
            }
            suites.add(new CipherSuite(id, aa, ca, ia));
        }
        return suites;
    }

    public static CipherSuite getEmpty() {
        return new CipherSuite(0, 0, 0, 0);
    }
}

