/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.sol;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolAckState;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolInboundMessage;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolInboundStatusField;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolOperation;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolOutboundMessage;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolOutboundOperationField;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.coding.sol.SolResponseData;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class SolCoder
extends PayloadCoder {
    private final byte[] message;
    private final byte ackNackSequenceNumber;
    private final byte acceptedCharacters;
    private final SolAckState ackState;
    private final Set<SolOperation> operations;
    private boolean acknowledgeOnly;

    public SolCoder(byte[] message, byte ackNackSequenceNumber, byte acceptedCharacters, SolAckState ackState, Set<SolOperation> operations, CipherSuite cipherSuite) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.message = message;
        this.ackNackSequenceNumber = ackNackSequenceNumber;
        this.acceptedCharacters = acceptedCharacters;
        this.ackState = ackState;
        this.operations = operations;
    }

    public SolCoder(byte[] message, CipherSuite cipherSuite) {
        this(message, 0, 0, SolAckState.ACK, new HashSet<SolOperation>(), cipherSuite);
    }

    public SolCoder(Set<SolOperation> operations, CipherSuite cipherSuite) {
        this(new byte[]{0}, 0, 0, SolAckState.ACK, operations, cipherSuite);
    }

    public SolCoder(byte ackNackSequenceNumber, byte acceptedCharacters, SolAckState ackState, CipherSuite cipherSuite) {
        this(null, ackNackSequenceNumber, acceptedCharacters, ackState, new HashSet<SolOperation>(), cipherSuite);
        this.acknowledgeOnly = true;
    }

    @Override
    public PayloadType getSupportedPayloadType() {
        return PayloadType.Sol;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte actualSequenceNumber = this.acknowledgeOnly ? (byte)0 : TypeConverter.intToByte(sequenceNumber);
        SolOutboundMessage request = new SolOutboundMessage(actualSequenceNumber, this.ackNackSequenceNumber, this.acceptedCharacters, new SolOutboundOperationField(this.ackState, this.operations));
        if (this.message != null && this.message.length > 0) {
            request.setData(this.message);
        }
        return request;
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        SolInboundMessage payload = (SolInboundMessage)message.getPayload();
        SolInboundStatusField statusField = payload.getStatusField();
        return new SolResponseData(payload.getAckNackSequenceNumber(), statusField.getAckState(), statusField.getStatuses(), payload.getAcceptedCharacterCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SolCoder solCoder = (SolCoder)o;
        if (this.ackNackSequenceNumber != solCoder.ackNackSequenceNumber) {
            return false;
        }
        if (this.acceptedCharacters != solCoder.acceptedCharacters) {
            return false;
        }
        if (this.acknowledgeOnly != solCoder.acknowledgeOnly) {
            return false;
        }
        if (!Arrays.equals(this.message, solCoder.message)) {
            return false;
        }
        if (this.ackState != solCoder.ackState) {
            return false;
        }
        return this.operations != null ? this.operations.equals(solCoder.operations) : solCoder.operations == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.message);
        result = 31 * result + this.ackNackSequenceNumber;
        result = 31 * result + this.acceptedCharacters;
        result = 31 * result + (this.ackState != null ? this.ackState.hashCode() : 0);
        result = 31 * result + (this.operations != null ? this.operations.hashCode() : 0);
        result = 31 * result + (this.acknowledgeOnly ? 1 : 0);
        return result;
    }
}

