/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection;

import java.io.IOException;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolAckState;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolInboundMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv20Message;
import org.sentrysoftware.ipmi.core.connection.Connection;
import org.sentrysoftware.ipmi.core.connection.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolMessageHandler
extends MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(SolMessageHandler.class);

    public SolMessageHandler(Connection connection, int timeout) throws IOException {
        super(connection, timeout, 1, 15);
    }

    @Override
    protected void handleIncomingMessageInternal(Ipmiv20Message message) {
        SolInboundMessage payload = (SolInboundMessage)message.getPayload();
        if (payload.isAcknowledgeMessage()) {
            this.handleIncomingAcknowledgeMessage(message, payload);
        }
        if (payload.isDataCarrier()) {
            this.handleIncomingDataMessage(payload);
        }
    }

    private void handleIncomingAcknowledgeMessage(Ipmiv20Message message, SolInboundMessage payload) {
        PayloadCoder coder = this.messageQueue.getMessageFromQueue(payload.getAckNackSequenceNumber());
        byte tag = payload.getAckNackSequenceNumber();
        logger.debug("Received message with tag " + tag);
        if (coder == null) {
            logger.debug("No message tagged with " + tag + " in queue. Dropping orphan message.");
            return;
        }
        try {
            ResponseData responseData = coder.getResponseData(message);
            this.connection.notifyResponseListeners(this.connection.getHandle(), tag, responseData, null);
        }
        catch (Exception e) {
            this.connection.notifyResponseListeners(this.connection.getHandle(), tag, null, e);
        }
        if (payload.getStatusField().getAckState() == SolAckState.ACK || payload.getAcceptedCharacterCount() > 0) {
            this.messageQueue.remove(payload.getAckNackSequenceNumber());
        }
    }

    private void handleIncomingDataMessage(SolInboundMessage payload) {
        this.connection.notifyRequestListeners(payload);
    }
}

