/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpDecoder;
import org.sentrysoftware.ipmi.core.sm.MachineObserver;
import org.sentrysoftware.ipmi.core.sm.actions.StateMachineAction;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.states.SessionValid;
import org.sentrysoftware.ipmi.core.sm.states.State;
import org.sentrysoftware.ipmi.core.sm.states.Uninitialized;
import org.sentrysoftware.ipmi.core.transport.Messenger;
import org.sentrysoftware.ipmi.core.transport.UdpListener;
import org.sentrysoftware.ipmi.core.transport.UdpMessage;

public class StateMachine
implements UdpListener {
    private List<MachineObserver> observers;
    private State current;
    private Messenger messenger;
    private InetAddress remoteMachineAddress;
    private int remoteMachinePort;
    private boolean initialized;

    public State getCurrent() {
        return this.current;
    }

    public void setCurrent(State current) {
        this.current = current;
        current.onEnter(this);
    }

    public StateMachine(Messenger messenger) {
        this.messenger = messenger;
        this.observers = new ArrayList<MachineObserver>();
        this.initialized = false;
    }

    public void sendMessage(byte[] message) throws IOException {
        UdpMessage udpMessage = new UdpMessage();
        udpMessage.setAddress(this.getRemoteMachineAddress());
        udpMessage.setPort(this.getRemoteMachinePort());
        udpMessage.setMessage(message);
        this.messenger.send(udpMessage);
    }

    public InetAddress getRemoteMachineAddress() {
        return this.remoteMachineAddress;
    }

    public int getRemoteMachinePort() {
        return this.remoteMachinePort;
    }

    public void doExternalAction(StateMachineAction action) {
        for (MachineObserver observer : this.observers) {
            if (observer == null) continue;
            observer.notify(action);
        }
    }

    public void start(InetAddress address, int port) {
        this.messenger.register(this);
        this.remoteMachineAddress = address;
        this.remoteMachinePort = port;
        this.setCurrent(new Uninitialized());
        this.initialized = true;
    }

    public void stop() {
        this.messenger.unregister(this);
        this.initialized = false;
    }

    public boolean isActive() {
        return this.initialized;
    }

    public void doTransition(StateMachineEvent event) {
        if (!this.initialized) {
            throw new NullPointerException("State machine not started");
        }
        this.current.doTransition(this, event);
    }

    @Override
    public void notifyMessage(UdpMessage message) {
        if (message.getAddress().equals(this.getRemoteMachineAddress()) && message.getPort() == this.getRemoteMachinePort()) {
            this.current.doAction(this, RmcpDecoder.decode(message.getMessage()));
        }
    }

    public void register(MachineObserver observer) {
        this.observers.add(observer);
    }

    public boolean isSessionChallenging() {
        return !this.initialized || this.getCurrent().getClass() == SessionValid.class;
    }
}

