/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilities;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.ProtocolDecoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv15Decoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.ResponseAction;
import org.sentrysoftware.ipmi.core.sm.events.AuthenticationCapabilitiesReceived;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.events.Timeout;
import org.sentrysoftware.ipmi.core.sm.states.Authcap;
import org.sentrysoftware.ipmi.core.sm.states.Ciphers;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class AuthcapWaiting
extends State {
    private int tag;

    public AuthcapWaiting(int tag) {
        this.tag = tag;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Ciphers());
        } else if (machineEvent instanceof AuthenticationCapabilitiesReceived) {
            stateMachine.setCurrent(new Authcap());
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) == AuthenticationType.RMCPPlus) {
            return;
        }
        Protocolv15Decoder decoder = new Protocolv15Decoder();
        IpmiMessage ipmiMessage = null;
        try {
            ipmiMessage = decoder.decode(message);
            GetChannelAuthenticationCapabilities capabilities = new GetChannelAuthenticationCapabilities();
            if (capabilities.isCommandResponse(ipmiMessage) && TypeConverter.byteToInt(((IpmiLanResponse)ipmiMessage.getPayload()).getSequenceNumber()) == this.tag) {
                stateMachine.doExternalAction(new ResponseAction(capabilities.getResponseData(ipmiMessage)));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

