/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.Encoder;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelCipherSuites;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.ProtocolDecoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv20Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv20Encoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.ResponseAction;
import org.sentrysoftware.ipmi.core.sm.events.DefaultAck;
import org.sentrysoftware.ipmi.core.sm.events.GetChannelCipherSuitesPending;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.events.Timeout;
import org.sentrysoftware.ipmi.core.sm.states.Ciphers;
import org.sentrysoftware.ipmi.core.sm.states.State;
import org.sentrysoftware.ipmi.core.sm.states.Uninitialized;

public class CiphersWaiting
extends State {
    private int index;
    private int tag;

    public CiphersWaiting(int index, int tag) {
        this.index = index;
        this.tag = tag;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Uninitialized());
        } else if (machineEvent instanceof GetChannelCipherSuitesPending) {
            GetChannelCipherSuitesPending event = (GetChannelCipherSuitesPending)machineEvent;
            GetChannelCipherSuites cipherSuites = new GetChannelCipherSuites(TypeConverter.intToByte(14), TypeConverter.intToByte(this.index + 1));
            try {
                this.tag = event.getSequenceNumber();
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), cipherSuites, event.getSequenceNumber(), 0, 0));
                ++this.index;
            }
            catch (Exception e) {
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else if (machineEvent instanceof DefaultAck) {
            stateMachine.setCurrent(new Ciphers());
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) != AuthenticationType.RMCPPlus) {
            return;
        }
        if (Protocolv20Decoder.decodeSessionID(message) != 0) {
            return;
        }
        if (Protocolv20Decoder.decodePayloadType(message.getData()[1]) != PayloadType.Ipmi) {
            return;
        }
        Protocolv20Decoder decoder = new Protocolv20Decoder(CipherSuite.getEmpty());
        if (decoder.decodeAuthentication(message.getData()[1])) {
            return;
        }
        IpmiMessage ipmiMessage = null;
        try {
            ipmiMessage = decoder.decode(message);
            GetChannelCipherSuites suites = new GetChannelCipherSuites();
            if (suites.isCommandResponse(ipmiMessage) && TypeConverter.byteToInt(((IpmiLanResponse)ipmiMessage.getPayload()).getSequenceNumber()) == this.tag) {
                stateMachine.doExternalAction(new ResponseAction(suites.getResponseData(ipmiMessage)));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

