/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.Encoder;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv20Encoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.events.OpenSessionAck;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.states.Rakp1Waiting;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class OpenSessionComplete
extends State {
    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof OpenSessionAck) {
            OpenSessionAck event = (OpenSessionAck)machineEvent;
            Rakp1 rakp1 = new Rakp1(event.getManagedSystemSessionId(), event.getPrivilegeLevel(), event.getUsername(), event.getPassword(), event.getBmcKey(), event.getCipherSuite());
            try {
                stateMachine.setCurrent(new Rakp1Waiting(event.getSequenceNumber(), rakp1));
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), rakp1, event.getSequenceNumber(), 0, 0));
            }
            catch (Exception e) {
                stateMachine.setCurrent(this);
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
    }
}

