/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.Encoder;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp3;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv20Encoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.GetSikAction;
import org.sentrysoftware.ipmi.core.sm.events.Rakp2Ack;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.states.Rakp3Waiting;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class Rakp1Complete
extends State {
    private Rakp1 rakp1;

    public Rakp1Complete(Rakp1 rakp1) {
        this.rakp1 = rakp1;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Rakp2Ack) {
            Rakp2Ack event = (Rakp2Ack)machineEvent;
            Rakp3 rakp3 = new Rakp3(event.getStatusCode(), event.getManagedSystemSessionId(), event.getCipherSuite(), this.rakp1, event.getRakp1ResponseData());
            try {
                stateMachine.setCurrent(new Rakp3Waiting(event.getSequenceNumber(), this.rakp1, event.getRakp1ResponseData(), event.getCipherSuite()));
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), rakp3, event.getSequenceNumber(), 0, 0));
                stateMachine.doExternalAction(new GetSikAction(this.rakp1.calculateSik(event.getRakp1ResponseData())));
            }
            catch (Exception e) {
                stateMachine.setCurrent(this);
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
    }
}

