/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp1ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.Rakp3;
import org.sentrysoftware.ipmi.core.coding.payload.PlainMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.PlainCommandv20Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.ProtocolDecoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv20Decoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.ResponseAction;
import org.sentrysoftware.ipmi.core.sm.events.DefaultAck;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.events.Timeout;
import org.sentrysoftware.ipmi.core.sm.states.Authcap;
import org.sentrysoftware.ipmi.core.sm.states.Rakp3Complete;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class Rakp3Waiting
extends State {
    private Rakp1 rakp1;
    private Rakp1ResponseData rakp1ResponseData;
    private CipherSuite cipherSuite;
    private int tag;

    public Rakp3Waiting(int tag, Rakp1 rakp1, Rakp1ResponseData rakp1ResponseData, CipherSuite cipherSuite) {
        this.rakp1 = rakp1;
        this.rakp1ResponseData = rakp1ResponseData;
        this.cipherSuite = cipherSuite;
        this.tag = tag;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof DefaultAck) {
            stateMachine.setCurrent(new Rakp3Complete());
        } else if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Authcap());
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) != AuthenticationType.RMCPPlus) {
            return;
        }
        PlainCommandv20Decoder decoder = new PlainCommandv20Decoder(CipherSuite.getEmpty());
        if (Protocolv20Decoder.decodePayloadType(message.getData()[1]) != PayloadType.Rakp4) {
            return;
        }
        IpmiMessage ipmiMessage = null;
        Rakp3 rakp3 = new Rakp3(this.cipherSuite, this.rakp1, this.rakp1ResponseData);
        try {
            ipmiMessage = decoder.decode(message);
            if (rakp3.isCommandResponse(ipmiMessage) && TypeConverter.byteToInt(((PlainMessage)ipmiMessage.getPayload()).getPayloadData()[0]) == this.tag) {
                stateMachine.doExternalAction(new ResponseAction(rakp3.getResponseData(ipmiMessage)));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

