/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.ipmi;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;

public class IpmiConfiguration
implements IConfiguration {
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private final Long timeout;
    private String username;
    private char[] password;
    private boolean skipAuth;
    private String bmcKey;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;

    public String toString() {
        Object description = "IPMI";
        if (this.username != null) {
            description = (String)description + " as " + this.username;
        }
        return description;
    }

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, "IPMI", this.timeout));
    }

    public IConfiguration copy() {
        return IpmiConfiguration.builder().bmcKey(this.bmcKey).password(this.password).skipAuth(this.skipAuth).timeout(this.timeout).username(this.username).hostname(this.hostname).build();
    }

    private static Long $default$timeout() {
        return 120L;
    }

    public static IpmiConfigurationBuilder builder() {
        return new IpmiConfigurationBuilder();
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isSkipAuth() {
        return this.skipAuth;
    }

    public String getBmcKey() {
        return this.bmcKey;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setSkipAuth(boolean skipAuth) {
        this.skipAuth = skipAuth;
    }

    public void setBmcKey(String bmcKey) {
        this.bmcKey = bmcKey;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IpmiConfiguration)) {
            return false;
        }
        IpmiConfiguration other = (IpmiConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSkipAuth() != other.isSkipAuth()) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$bmcKey = this.getBmcKey();
        String other$bmcKey = other.getBmcKey();
        if (this$bmcKey == null ? other$bmcKey != null : !this$bmcKey.equals(other$bmcKey)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IpmiConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSkipAuth() ? 79 : 97);
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $bmcKey = this.getBmcKey();
        result = result * 59 + ($bmcKey == null ? 43 : $bmcKey.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    public IpmiConfiguration(Long timeout, String username, char[] password, boolean skipAuth, String bmcKey, String hostname) {
        this.timeout = timeout;
        this.username = username;
        this.password = password;
        this.skipAuth = skipAuth;
        this.bmcKey = bmcKey;
        this.hostname = hostname;
    }

    public IpmiConfiguration() {
        this.timeout = IpmiConfiguration.$default$timeout();
    }

    public static class IpmiConfigurationBuilder {
        private boolean timeout$set;
        private Long timeout$value;
        private String username;
        private char[] password;
        private boolean skipAuth;
        private String bmcKey;
        private String hostname;

        IpmiConfigurationBuilder() {
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        public IpmiConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        public IpmiConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public IpmiConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        public IpmiConfigurationBuilder skipAuth(boolean skipAuth) {
            this.skipAuth = skipAuth;
            return this;
        }

        public IpmiConfigurationBuilder bmcKey(String bmcKey) {
            this.bmcKey = bmcKey;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        public IpmiConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public IpmiConfiguration build() {
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = IpmiConfiguration.$default$timeout();
            }
            return new IpmiConfiguration(timeout$value, this.username, this.password, this.skipAuth, this.bmcKey, this.hostname);
        }

        public String toString() {
            return "IpmiConfiguration.IpmiConfigurationBuilder(timeout$value=" + this.timeout$value + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", skipAuth=" + this.skipAuth + ", bmcKey=" + this.bmcKey + ", hostname=" + this.hostname + ")";
        }
    }
}

