/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.ipmi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.sentrysoftware.ipmi.client.IpmiClient;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.ArrayHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.IpmiCriterion;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.ipmi.IpmiConfiguration;
import org.sentrysoftware.metricshub.extension.ipmi.IpmiRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpmiExtension
implements IProtocolExtension {
    private static final Logger log = LoggerFactory.getLogger(IpmiExtension.class);
    private static final String IDENTIFIER = "ipmi";
    private IpmiRequestExecutor ipmiRequestExecutor = new IpmiRequestExecutor();

    public boolean isValidConfiguration(IConfiguration configuration) {
        return configuration instanceof IpmiConfiguration;
    }

    public Set<Class<? extends Source>> getSupportedSources() {
        return Set.of(IpmiSource.class);
    }

    public Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> getConfigurationToSourceMapping() {
        return Map.of(IpmiConfiguration.class, Set.of(IpmiSource.class));
    }

    public Set<Class<? extends Criterion>> getSupportedCriteria() {
        return Set.of(IpmiCriterion.class);
    }

    public Optional<Boolean> checkProtocol(TelemetryManager telemetryManager) {
        String hostname = telemetryManager.getHostname(List.of(IpmiConfiguration.class));
        String ipmiResult = null;
        IpmiConfiguration ipmiConfiguration = (IpmiConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(IpmiConfiguration.class);
        if (ipmiConfiguration == null) {
            return Optional.empty();
        }
        log.info("Hostname {} - Performing {} protocol health check.", (Object)hostname, (Object)this.getIdentifier());
        log.info("Hostname {} - Checking IPMI protocol status. Sending a IPMI 'Get Chassis Status As String Result' request.", (Object)hostname);
        try {
            ipmiResult = IpmiClient.getChassisStatusAsStringResult(new IpmiClientConfiguration(hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.getPassword(), ArrayHelper.hexToByteArray((String)ipmiConfiguration.getBmcKey()), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout()));
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking IPMI protocol status. IPMI exception when performing a IPMI 'Get Chassis Status As String Result' query: ", (Object)hostname, (Object)e);
        }
        return Optional.of(ipmiResult != null);
    }

    public SourceTable processSource(Source source, String connectorId, TelemetryManager telemetryManager) {
        IpmiConfiguration ipmiConfiguration = (IpmiConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(IpmiConfiguration.class);
        if (ipmiConfiguration == null) {
            log.warn("Hostname {} - The IPMI credentials are not configured. Cannot process IPMI-over-LAN source.", (Object)telemetryManager.getHostname());
            return SourceTable.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(IpmiConfiguration.class));
        try {
            String result = this.ipmiRequestExecutor.executeIpmiGetSensors(hostname, ipmiConfiguration);
            if (result != null) {
                return SourceTable.builder().rawData(result).build();
            }
            log.error("Hostname {} - IPMI-over-LAN request returned <null> result. Returning an empty table.", (Object)hostname);
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)connectorId, (String)source.getKey(), (String)"IPMI-over-LAN", (String)hostname, (Throwable)e);
        }
        return SourceTable.empty();
    }

    public CriterionTestResult processCriterion(Criterion criterion, String connectorId, TelemetryManager telemetryManager) {
        IpmiConfiguration configuration = (IpmiConfiguration)telemetryManager.getHostConfiguration().getConfigurations().get(IpmiConfiguration.class);
        if (configuration == null) {
            log.debug("Hostname {} - The IPMI credentials are not configured for this host. Cannot process IPMI-over-LAN detection.", (Object)telemetryManager.getHostname());
            return CriterionTestResult.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(IpmiConfiguration.class));
        try {
            String result = this.ipmiRequestExecutor.executeIpmiDetection(hostname, configuration);
            if (result == null) {
                return CriterionTestResult.builder().message("Received <null> result after connecting to the IPMI BMC chip with the IPMI-over-LAN interface.").build();
            }
            return CriterionTestResult.builder().result(result).message("Successfully connected to the IPMI BMC chip with the IPMI-over-LAN interface.").success(true).build();
        }
        catch (Exception e) {
            String message = String.format("Hostname %s - Cannot execute IPMI-over-LAN command to get the chassis status. Exception: %s", hostname, e.getMessage());
            log.debug(message, (Throwable)e);
            return CriterionTestResult.builder().message(message).build();
        }
    }

    public boolean isSupportedConfigurationType(String configurationType) {
        return IDENTIFIER.equalsIgnoreCase(configurationType);
    }

    public IConfiguration buildConfiguration(String configurationType, JsonNode jsonNode, UnaryOperator<char[]> decrypt) throws InvalidConfigurationException {
        try {
            char[] password;
            IpmiConfiguration ipmiConfiguration = (IpmiConfiguration)IpmiExtension.newObjectMapper().treeToValue((TreeNode)jsonNode, IpmiConfiguration.class);
            if (decrypt != null && (password = ipmiConfiguration.getPassword()) != null) {
                ipmiConfiguration.setPassword((char[])decrypt.apply(password));
            }
            return ipmiConfiguration;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error while reading IPMI Configuration. Error: %s", e.getMessage());
            log.error(errorMessage);
            log.debug("Error while reading IPMI Configuration. Stack trace:", (Throwable)e);
            throw new InvalidConfigurationException(errorMessage, (Throwable)e);
        }
    }

    public static JsonMapper newObjectMapper() {
        return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false)).build();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String executeQuery(IConfiguration configuration, JsonNode query) throws Exception {
        String hostname = configuration.getHostname();
        return this.ipmiRequestExecutor.executeIpmiGetSensors(hostname, (IpmiConfiguration)configuration);
    }
}

