/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.ipmi;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.sentrysoftware.ipmi.client.IpmiClient;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.metricshub.engine.common.helpers.ArrayHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.extension.ipmi.IpmiConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpmiRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(IpmiRequestExecutor.class);

    @WithSpan(value="IPMI Chassis Status")
    public String executeIpmiDetection(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="ipmi.config") @NonNull IpmiConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        if (ipmiConfiguration == null) {
            throw new NullPointerException("ipmiConfiguration is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing IPMI detection request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout()}));
        long startTime = System.currentTimeMillis();
        String result = IpmiClient.getChassisStatusAsStringResult(IpmiRequestExecutor.buildIpmiConfiguration(hostname, ipmiConfiguration));
        long responseTime = System.currentTimeMillis() - startTime;
        LoggingHelper.trace(() -> log.trace("Executed IPMI detection request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout(), result, responseTime}));
        return result;
    }

    private static IpmiClientConfiguration buildIpmiConfiguration(@NonNull String hostname, @NonNull IpmiConfiguration ipmiConfiguration) {
        if (hostname == null) {
            throw new NullPointerException("hostname is marked non-null but is null");
        }
        if (ipmiConfiguration == null) {
            throw new NullPointerException("ipmiConfiguration is marked non-null but is null");
        }
        String username = ipmiConfiguration.getUsername();
        char[] password = ipmiConfiguration.getPassword();
        Long timeout = ipmiConfiguration.getTimeout();
        return new IpmiClientConfiguration(hostname, username, password, ArrayHelper.hexToByteArray((String)ipmiConfiguration.getBmcKey()), ipmiConfiguration.isSkipAuth(), timeout, 0L);
    }

    @WithSpan(value="IPMI Sensors")
    public String executeIpmiGetSensors(@SpanAttribute(value="host.hostname") String hostname, @SpanAttribute(value="ipmi.config") @NonNull IpmiConfiguration ipmiConfiguration) throws InterruptedException, ExecutionException, TimeoutException {
        if (ipmiConfiguration == null) {
            throw new NullPointerException("ipmiConfiguration is marked non-null but is null");
        }
        LoggingHelper.trace(() -> log.trace("Executing IPMI FRUs and Sensors request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout()}));
        long startTime = System.currentTimeMillis();
        String result = IpmiClient.getFrusAndSensorsAsStringResult(IpmiRequestExecutor.buildIpmiConfiguration(hostname, ipmiConfiguration));
        long responseTime = System.currentTimeMillis() - startTime;
        LoggingHelper.trace(() -> log.trace("Executed IPMI FRUs and Sensors request:\n- Hostname: {}\n- Username: {}\n- SkipAuth: {}\n- Timeout: {} s\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout(), result, responseTime}));
        return result;
    }
}

