/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusApplicationContextResourceResolver;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.resource.ResourceManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class Jsr250BeanPostProcessor
implements DestructionAwareBeanPostProcessor,
Ordered,
ApplicationContextAware {
    private ResourceManager resourceManager;
    private ApplicationContext context;
    private boolean isProcessing = true;

    Jsr250BeanPostProcessor() {
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
        try {
            Class<?> cls = Class.forName("org.springframework.context.annotation.CommonAnnotationBeanPostProcessor");
            this.isProcessing = this.context.getBeanNamesForType(cls, true, false).length == 0;
        }
        catch (ClassNotFoundException e) {
            this.isProcessing = true;
        }
    }

    @Override
    public int getOrder() {
        return 1010;
    }

    private boolean injectable(Object bean2, String beanId) {
        return !"cxf".equals(beanId) && ResourceInjector.processable(bean2.getClass(), bean2);
    }

    private ResourceManager getResourceManager(Object bean2) {
        if (this.resourceManager == null) {
            boolean temp = this.isProcessing;
            this.isProcessing = false;
            if (bean2 instanceof ResourceManager) {
                this.resourceManager = (ResourceManager)bean2;
                this.resourceManager.addResourceResolver(new BusApplicationContextResourceResolver(this.context));
            } else if (bean2 instanceof Bus) {
                Bus b = (Bus)bean2;
                ResourceManager m = b.getExtension(ResourceManager.class);
                if (m != null) {
                    this.resourceManager = m;
                    if (!(b instanceof SpringBus)) {
                        this.resourceManager.addResourceResolver(new BusApplicationContextResourceResolver(this.context));
                    }
                }
            } else {
                ResourceManager m = null;
                Bus b = null;
                try {
                    m = (ResourceManager)this.context.getBean(ResourceManager.class.getName());
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
                if (m == null) {
                    b = (Bus)this.context.getBean("cxf");
                    m = b.getExtension(ResourceManager.class);
                }
                if (m != null) {
                    this.resourceManager = m;
                    if (!(b instanceof SpringBus)) {
                        this.resourceManager.addResourceResolver(new BusApplicationContextResourceResolver(this.context));
                    }
                }
            }
            this.isProcessing = temp;
        }
        return this.resourceManager;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanId) {
        if (!this.isProcessing) {
            if (this.resourceManager == null && bean2 instanceof ResourceManager) {
                this.resourceManager = (ResourceManager)bean2;
                this.resourceManager.addResourceResolver(new BusApplicationContextResourceResolver(this.context));
            }
            return bean2;
        }
        if (bean2 != null && this.injectable(bean2, beanId)) {
            new ResourceInjector(this.getResourceManager(bean2)).construct(bean2);
        }
        return bean2;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanId) {
        if (!this.isProcessing) {
            return bean2;
        }
        if (bean2 instanceof Bus) {
            this.getResourceManager(bean2);
        }
        if (bean2 != null && this.injectable(bean2, beanId)) {
            new ResourceInjector(this.getResourceManager(bean2)).inject(bean2);
        }
        return bean2;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean2, String beanId) {
        if (!this.isProcessing) {
            return;
        }
        if (bean2 != null && this.injectable(bean2, beanId)) {
            new ResourceInjector(this.getResourceManager(bean2)).destroy(bean2);
        }
    }

    @Override
    public boolean requiresDestruction(Object bean2) {
        return this.isProcessing;
    }
}

