/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CopyingOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.CXFHttpAsyncRequestProducer;
import org.apache.cxf.transport.http.asyncclient.CXFHttpAsyncResponseConsumer;
import org.apache.cxf.transport.http.asyncclient.CXFHttpRequest;
import org.apache.cxf.transport.http.asyncclient.CXFResponseCallback;
import org.apache.cxf.transport.http.asyncclient.SharedInputBuffer;
import org.apache.cxf.transport.http.asyncclient.SharedOutputBuffer;
import org.apache.cxf.transport.https.HttpsURLConnectionInfo;
import org.apache.cxf.transport.https.SSLUtils;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;

public class AsyncHTTPConduit
extends URLConnectionHTTPConduit {
    public static final String USE_ASYNC = "use.async.http.conduit";
    final AsyncHTTPConduitFactory factory;
    volatile int lastTlsHash = -1;
    volatile Object sslState;
    volatile URI sslURL;
    volatile SSLContext sslContext;
    volatile SSLSession session;
    volatile CloseableHttpAsyncClient client;

    public AsyncHTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t, AsyncHTTPConduitFactory factory) throws IOException {
        super(b, ei, t);
        this.factory = factory;
    }

    public synchronized CloseableHttpAsyncClient getHttpAsyncClient() throws IOException {
        if (this.client == null) {
            this.client = this.factory.createClient(this);
        }
        if (this.client == null) {
            throw new IOException("HttpAsyncClient is null");
        }
        return this.client;
    }

    public AsyncHTTPConduitFactory getAsyncHTTPConduitFactory() {
        return this.factory;
    }

    @Override
    protected void setupConnection(Message message, Address address, HTTPClientPolicy csPolicy) throws IOException {
        String s;
        if (this.factory.isShutdown()) {
            message.put(USE_ASYNC, Boolean.FALSE);
            super.setupConnection(message, address, csPolicy);
            return;
        }
        this.propagateJaxwsSpecTimeoutSettings(message, csPolicy);
        boolean addressChanged = false;
        URI uri = address.getURI();
        String uriString = uri.toString();
        if (uriString.startsWith("hc://")) {
            try {
                uriString = uriString.substring(5);
                uri = new URI(uriString);
                addressChanged = true;
            }
            catch (URISyntaxException ex) {
                throw new MalformedURLException("unsupport uri: " + uriString);
            }
        }
        if (!"http".equals(s = uri.getScheme()) && !"https".equals(s)) {
            throw new MalformedURLException("unknown protocol: " + s);
        }
        Object o = message.getContextualProperty(USE_ASYNC);
        if (o == null) {
            o = this.factory.getUseAsyncPolicy();
        }
        switch (AsyncHTTPConduitFactory.UseAsyncPolicy.getPolicy(o)) {
            case ALWAYS: {
                o = true;
                break;
            }
            case NEVER: {
                o = false;
                break;
            }
            default: {
                o = !message.getExchange().isSynchronous();
            }
        }
        TLSClientParameters clientParameters = message.get(TLSClientParameters.class);
        if (clientParameters == null) {
            clientParameters = this.tlsClientParameters;
        }
        if ("https".equals(uri.getScheme()) && clientParameters != null && clientParameters.getSSLSocketFactory() != null) {
            o = false;
        }
        if (!PropertyUtils.isTrue(o)) {
            message.put(USE_ASYNC, Boolean.FALSE);
            super.setupConnection(message, addressChanged ? new Address(uriString, uri) : address, csPolicy);
            return;
        }
        if (StringUtils.isEmpty(uri.getPath())) {
            uri = uri.resolve("/");
        }
        message.put(USE_ASYNC, Boolean.TRUE);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Asynchronous connection to " + uri.toString() + " has been set up");
        }
        message.put("http.scheme", uri.getScheme());
        String httpRequestMethod = (String)message.get("org.apache.cxf.request.method");
        if (httpRequestMethod == null) {
            httpRequestMethod = "POST";
            message.put("org.apache.cxf.request.method", httpRequestMethod);
        }
        final CXFHttpRequest e = new CXFHttpRequest(httpRequestMethod);
        BasicHttpEntity entity = new BasicHttpEntity(){

            @Override
            public boolean isRepeatable() {
                return e.getOutputStream().retransmitable();
            }
        };
        entity.setChunked(true);
        entity.setContentType((String)message.get("Content-Type"));
        e.setURI(uri);
        e.setEntity(entity);
        RequestConfig.Builder b = RequestConfig.custom().setConnectTimeout((int)csPolicy.getConnectionTimeout()).setSocketTimeout((int)csPolicy.getReceiveTimeout()).setConnectionRequestTimeout((int)csPolicy.getConnectionRequestTimeout());
        Proxy p = this.proxyFactory.createProxy(csPolicy, uri);
        if (p != null && p.type() != Proxy.Type.DIRECT) {
            InetSocketAddress isa = (InetSocketAddress)p.address();
            HttpHost proxy = new HttpHost(isa.getHostString(), isa.getPort());
            b.setProxy(proxy);
        }
        e.setConfig(b.build());
        message.put(CXFHttpRequest.class, e);
    }

    private void propagateJaxwsSpecTimeoutSettings(Message message, HTTPClientPolicy csPolicy) {
        int receiveTimeout = AsyncHTTPConduit.determineReceiveTimeout(message, csPolicy);
        if (csPolicy.getReceiveTimeout() == 60000L) {
            csPolicy.setReceiveTimeout(receiveTimeout);
        }
        int connectionTimeout = AsyncHTTPConduit.determineConnectionTimeout(message, csPolicy);
        if (csPolicy.getConnectionTimeout() == 30000L) {
            csPolicy.setConnectionTimeout(connectionTimeout);
        }
    }

    @Override
    protected OutputStream createOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold) throws IOException {
        if (Boolean.TRUE.equals(message.get(USE_ASYNC))) {
            CXFHttpRequest entity = message.get(CXFHttpRequest.class);
            AsyncWrappedOutputStream out = new AsyncWrappedOutputStream(message, needToCacheRequest, isChunking, chunkThreshold, this.getConduitName(), entity.getURI());
            entity.setOutputStream(out);
            return out;
        }
        return super.createOutputStream(message, needToCacheRequest, isChunking, chunkThreshold);
    }

    public synchronized SSLContext getSSLContext(TLSClientParameters tlsClientParameters) throws GeneralSecurityException {
        SSLContext ctx;
        int hash = tlsClientParameters.hashCode();
        if (hash == this.lastTlsHash && this.sslContext != null) {
            return this.sslContext;
        }
        if (tlsClientParameters.getSslContext() != null) {
            ctx = tlsClientParameters.getSslContext();
        } else {
            String provider = tlsClientParameters.getJsseProvider();
            String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : "TLS";
            ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
            KeyManager[] keyManagers = tlsClientParameters.getKeyManagers();
            if (keyManagers == null) {
                keyManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultKeyStoreManagers(LOG);
            }
            KeyManager[] configuredKeyManagers = SSLUtils.configureKeyManagersWithCertAlias(tlsClientParameters, keyManagers);
            TrustManager[] trustManagers = tlsClientParameters.getTrustManagers();
            if (trustManagers == null) {
                trustManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultTrustStoreManagers(LOG);
            }
            ctx.init(configuredKeyManagers, trustManagers, tlsClientParameters.getSecureRandom());
            if (ctx.getClientSessionContext() != null) {
                ctx.getClientSessionContext().setSessionTimeout(tlsClientParameters.getSslCacheTimeout());
            }
        }
        this.sslContext = ctx;
        this.lastTlsHash = hash;
        this.sslState = null;
        this.sslURL = null;
        this.session = null;
        return ctx;
    }

    public void initializeSSLEngine(SSLContext sslcontext, SSLEngine sslengine) {
        TLSClientParameters tlsClientParameters = this.getTlsClientParameters();
        if (tlsClientParameters == null) {
            tlsClientParameters = new TLSClientParameters();
        }
        String[] cipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude(tlsClientParameters.getCipherSuites(), tlsClientParameters.getCipherSuitesFilter(), sslcontext.getSocketFactory().getDefaultCipherSuites(), org.apache.cxf.configuration.jsse.SSLUtils.getSupportedCipherSuites(sslcontext), LOG);
        sslengine.setEnabledCipherSuites(cipherSuites);
        String protocol = tlsClientParameters.getSecureSocketProtocol() != null ? tlsClientParameters.getSecureSocketProtocol() : sslcontext.getProtocol();
        String[] p = this.findProtocols(protocol, sslengine.getSupportedProtocols());
        if (p != null) {
            sslengine.setEnabledProtocols(p);
        }
    }

    private String[] findProtocols(String p, String[] options) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : options) {
            if (s.equals(p)) {
                return new String[]{p};
            }
            if (!s.startsWith(p)) continue;
            list.add(s);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public class AsyncWrappedOutputStream
    extends HTTPConduit.WrappedOutputStream
    implements CopyingOutputStream,
    WritableByteChannel {
        final HTTPClientPolicy csPolicy;
        CXFHttpRequest entity;
        BasicHttpEntity basicEntity;
        boolean isAsync;
        SharedInputBuffer inbuf;
        SharedOutputBuffer outbuf;
        volatile HttpResponse httpResponse;
        volatile Exception exception;
        private Future<Boolean> connectionFuture;
        private Object sessionLock;
        private boolean closed;

        public AsyncWrappedOutputStream(Message message, boolean needToCacheRequest, boolean isChunking, int chunkThreshold, String conduitName, URI uri) {
            super(AsyncHTTPConduit.this, message, needToCacheRequest, isChunking, chunkThreshold, conduitName, uri);
            this.sessionLock = new Object();
            this.csPolicy = AsyncHTTPConduit.this.getClient(message);
            this.entity = message.get(CXFHttpRequest.class);
            this.basicEntity = (BasicHttpEntity)this.entity.getEntity();
            this.basicEntity.setChunked(isChunking);
            HeapByteBufferAllocator allocator = new HeapByteBufferAllocator();
            int bufSize = this.csPolicy.getChunkLength() > 0 ? this.csPolicy.getChunkLength() : 16320;
            this.inbuf = new SharedInputBuffer(bufSize, allocator);
            this.outbuf = new SharedOutputBuffer(bufSize, allocator);
            this.isAsync = this.outMessage != null && this.outMessage.getExchange() != null && !this.outMessage.getExchange().isSynchronous();
        }

        public boolean retransmitable() {
            return this.cachedStream != null;
        }

        public CachedOutputStream getCachedStream() {
            return this.cachedStream;
        }

        @Override
        protected void setProtocolHeaders() throws IOException {
            Headers h = new Headers(this.outMessage);
            this.basicEntity.setContentType(h.determineContentType());
            boolean addHeaders = MessageUtils.getContextualBoolean(this.outMessage, "org.apache.cxf.http.add-headers", false);
            for (Map.Entry<String, List<String>> header : h.headerMap().entrySet()) {
                if ("Content-Type".equalsIgnoreCase(header.getKey())) continue;
                if (addHeaders || "Cookie".equalsIgnoreCase(header.getKey())) {
                    for (String s : header.getValue()) {
                        this.entity.addHeader("Cookie", s);
                    }
                } else if (!"Content-Length".equalsIgnoreCase(header.getKey())) {
                    StringBuilder b = new StringBuilder();
                    for (int i = 0; i < header.getValue().size(); ++i) {
                        b.append(header.getValue().get(i));
                        if (i + 1 >= header.getValue().size()) continue;
                        b.append(',');
                    }
                    this.entity.setHeader(header.getKey(), b.toString());
                }
                if (this.entity.containsHeader("User-Agent")) continue;
                this.entity.setHeader("User-Agent", Version.getCompleteVersionString());
            }
        }

        @Override
        protected void setFixedLengthStreamingMode(int i) {
            this.basicEntity.setChunked(false);
            this.basicEntity.setContentLength(i);
        }

        @Override
        public void thresholdReached() throws IOException {
            this.basicEntity.setChunked(this.chunking);
        }

        @Override
        protected void handleNoOutput() throws IOException {
            this.connect(false);
            this.outbuf.writeCompleted();
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int total = 0;
            if (this.buffer != null) {
                int pos = this.buffer.size();
                int len = this.threshold - pos;
                if (len > src.remaining()) {
                    len = src.remaining();
                }
                src.get(this.buffer.getRawBytes(), pos, len);
                this.buffer.setSize(this.buffer.size() + len);
                total += len;
                if (this.buffer.size() >= this.threshold) {
                    this.thresholdReached();
                    this.unBuffer();
                }
            }
            if (this.cachingForRetransmission) {
                this.wrappedStream.write(src.array(), src.position(), src.remaining());
                return src.remaining() + total;
            }
            return this.outbuf.write(src) + total;
        }

        @Override
        public int copyFrom(InputStream in) throws IOException {
            int count = 0;
            while (this.buffer != null) {
                int pos = this.buffer.size();
                int i = in.read(this.buffer.getRawBytes(), pos, this.threshold - pos);
                if (i > 0) {
                    this.buffer.setSize(pos + i);
                    if (this.buffer.size() >= this.threshold) {
                        this.thresholdReached();
                        this.unBuffer();
                    }
                    count += i;
                    continue;
                }
                return count;
            }
            count = this.cachingForRetransmission ? (count += IOUtils.copy(in, this.wrappedStream)) : (count += this.outbuf.copy(in));
            return count;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.chunking && this.wrappedStream instanceof CachedOutputStream) {
                CachedOutputStream out = (CachedOutputStream)this.wrappedStream;
                this.basicEntity.setContentLength(out.size());
                this.wrappedStream = null;
                this.handleHeadersTrustCaching();
                out.writeCacheTo(this.wrappedStream);
            }
            super.close();
        }

        @Override
        protected void onFirstWrite() throws IOException {
            if (this.chunking) {
                super.onFirstWrite();
            } else {
                this.wrappedStream = new CachedOutputStream();
            }
        }

        @Override
        protected void setupWrappedStream() throws IOException {
            this.connect(true);
            this.wrappedStream = new OutputStream(){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (AsyncWrappedOutputStream.this.exception instanceof IOException) {
                        throw (IOException)AsyncWrappedOutputStream.this.exception;
                    }
                    AsyncWrappedOutputStream.this.outbuf.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    if (AsyncWrappedOutputStream.this.exception instanceof IOException) {
                        throw (IOException)AsyncWrappedOutputStream.this.exception;
                    }
                    AsyncWrappedOutputStream.this.outbuf.write(b);
                }

                @Override
                public void close() throws IOException {
                    AsyncWrappedOutputStream.this.outbuf.writeCompleted();
                }
            };
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.wrappedStream);
                this.wrappedStream = this.cachedStream;
            }
        }

        protected void connect(boolean output) throws IOException {
            Registry asp;
            if (this.connectionFuture != null) {
                return;
            }
            CXFResponseCallback responseCallback = new CXFResponseCallback(){

                @Override
                public void responseReceived(HttpResponse response) {
                    AsyncWrappedOutputStream.this.setHttpResponse(response);
                }
            };
            FutureCallback<Boolean> callback = new FutureCallback<Boolean>(){

                @Override
                public void completed(Boolean result) {
                }

                @Override
                public void failed(Exception ex) {
                    AsyncWrappedOutputStream.this.setException(ex);
                    AsyncWrappedOutputStream.this.inbuf.shutdown();
                    AsyncWrappedOutputStream.this.outbuf.shutdown();
                }

                @Override
                public void cancelled() {
                    AsyncWrappedOutputStream.this.handleCancelled();
                    AsyncWrappedOutputStream.this.inbuf.shutdown();
                    AsyncWrappedOutputStream.this.outbuf.shutdown();
                }
            };
            if (!output) {
                this.entity.removeHeaders("Transfer-Encoding");
                this.entity.removeHeaders("Content-Type");
                this.entity.setEntity(null);
            }
            HttpClientContext ctx = HttpClientContext.create();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider(){

                @Override
                public Credentials getCredentials(AuthScope authscope) {
                    Credentials creds = super.getCredentials(authscope);
                    if (creds != null) {
                        return creds;
                    }
                    if (AsyncHTTPConduit.this.proxyAuthorizationPolicy != null && AsyncHTTPConduit.this.proxyAuthorizationPolicy.getUserName() != null) {
                        return new UsernamePasswordCredentials(AsyncHTTPConduit.this.proxyAuthorizationPolicy.getUserName(), AsyncHTTPConduit.this.proxyAuthorizationPolicy.getPassword());
                    }
                    return null;
                }
            };
            ctx.setCredentialsProvider(credsProvider);
            if ("https".equals(this.url.getScheme())) {
                try {
                    RegistryBuilder<NoopIOSessionStrategy> regBuilder = RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE);
                    TLSClientParameters tlsClientParameters = this.outMessage.get(TLSClientParameters.class);
                    if (tlsClientParameters == null) {
                        tlsClientParameters = AsyncHTTPConduit.this.getTlsClientParameters();
                    }
                    if (tlsClientParameters == null) {
                        tlsClientParameters = new TLSClientParameters();
                    }
                    final SSLContext sslcontext = AsyncHTTPConduit.this.getSSLContext(tlsClientParameters);
                    final HostnameVerifier verifier = SSLUtils.getHostnameVerifier(tlsClientParameters);
                    regBuilder.register("https", (NoopIOSessionStrategy)((Object)new SSLIOSessionStrategy(sslcontext){

                        @Override
                        protected void initializeEngine(SSLEngine engine) {
                            AsyncHTTPConduit.this.initializeSSLEngine(sslcontext, engine);
                        }

                        @Override
                        protected void verifySession(HttpHost host, IOSession iosession, SSLSession sslsession) throws SSLException {
                            if (!verifier.verify(host.getHostName(), sslsession)) {
                                throw new SSLException("Could not verify host " + host.getHostName());
                            }
                            iosession.setAttribute("cxf.handshake.done", Boolean.TRUE);
                            AsyncWrappedOutputStream.this.setSSLSession(sslsession);
                        }
                    }));
                    ctx.setAttribute("http.iosession-factory-registry", regBuilder.build());
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
            }
            if (AsyncHTTPConduit.this.sslURL != null && this.isSslTargetDifferent(AsyncHTTPConduit.this.sslURL, this.url)) {
                AsyncHTTPConduit.this.sslURL = null;
                AsyncHTTPConduit.this.sslState = null;
                AsyncHTTPConduit.this.session = null;
            }
            if (AsyncHTTPConduit.this.tlsClientParameters != null && AsyncHTTPConduit.this.tlsClientParameters.hashCode() == AsyncHTTPConduit.this.lastTlsHash) {
                ctx.setUserToken(AsyncHTTPConduit.this.sslState);
            }
            this.connectionFuture = new BasicFuture<Boolean>(callback);
            CloseableHttpAsyncClient c = AsyncHTTPConduit.this.getHttpAsyncClient();
            Credentials creds = (Credentials)this.outMessage.getContextualProperty(Credentials.class.getName());
            if (creds != null) {
                credsProvider.setCredentials(AuthScope.ANY, creds);
                ctx.setUserToken(creds.getUserPrincipal());
            }
            if ((asp = (Registry)this.outMessage.getContextualProperty(AuthSchemeProvider.class.getName())) != null) {
                ctx.setAuthSchemeRegistry(asp);
            }
            c.execute(new CXFHttpAsyncRequestProducer(this.entity, this.outbuf), new CXFHttpAsyncResponseConsumer(this, this.inbuf, responseCallback), (HttpContext)ctx, callback);
        }

        private boolean isSslTargetDifferent(URI lastURL, URI url) {
            return !lastURL.getScheme().equals(url.getScheme()) || !lastURL.getHost().equals(url.getHost()) || lastURL.getPort() != url.getPort();
        }

        protected boolean retrySetHttpResponse(HttpResponse r) {
            if (this.isAsync) {
                this.setHttpResponse(r);
            }
            return !this.isAsync;
        }

        protected synchronized void setHttpResponse(HttpResponse r) {
            this.httpResponse = r;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.notifyAll();
        }

        protected synchronized void setException(Exception ex) {
            this.exception = ex;
            if (this.isAsync) {
                try {
                    this.handleResponseOnWorkqueue(false, true);
                    this.isAsync = false;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
            this.notifyAll();
        }

        protected synchronized void handleCancelled() {
            this.notifyAll();
        }

        protected synchronized HttpResponse getHttpResponse() throws IOException {
            while (this.httpResponse == null) {
                if (this.exception == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.httpResponse != null) continue;
                this.outbuf.shutdown();
                this.inbuf.shutdown();
                if (this.exception != null) {
                    if (this.exception instanceof IOException) {
                        throw (IOException)this.exception;
                    }
                    if (this.exception instanceof RuntimeException) {
                        throw (RuntimeException)this.exception;
                    }
                    throw new IOException(this.exception);
                }
                throw new SocketTimeoutException("Read Timeout");
            }
            return this.httpResponse;
        }

        @Override
        protected void handleResponseAsync() throws IOException {
        }

        @Override
        protected void closeInputStream() throws IOException {
            byte[] bytes = new byte[1024];
            while (this.inbuf.read(bytes) > 0) {
            }
            this.inbuf.close();
            this.inbuf.shutdown();
        }

        @Override
        protected synchronized InputStream getInputStream() throws IOException {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.read(b, off, len);
                }

                @Override
                public int available() throws IOException {
                    return AsyncWrappedOutputStream.this.inbuf.available();
                }

                @Override
                public void close() throws IOException {
                    AsyncWrappedOutputStream.this.inbuf.close();
                }
            };
        }

        @Override
        protected boolean usingProxy() {
            return this.entity.getConfig().getProxy() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HttpsURLConnectionInfo getHttpsURLConnectionInfo() throws IOException {
            if ("http".equals(this.outMessage.get("http.scheme"))) {
                return null;
            }
            this.connect(true);
            Object object = this.sessionLock;
            synchronized (object) {
                if (AsyncHTTPConduit.this.session == null) {
                    try {
                        this.sessionLock.wait(this.csPolicy.getConnectionTimeout());
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (AsyncHTTPConduit.this.session == null) {
                    throw new IOException("No SSLSession detected");
                }
            }
            HostnameVerifier verifier = SSLUtils.getHostnameVerifier(AsyncHTTPConduit.this.tlsClientParameters);
            if (!verifier.verify(this.url.getHost(), AsyncHTTPConduit.this.session)) {
                throw new IOException("Could not verify host " + this.url.getHost());
            }
            String method = (String)this.outMessage.get("org.apache.cxf.request.method");
            String cipherSuite = null;
            Certificate[] localCerts = null;
            Principal principal = null;
            Certificate[] serverCerts = null;
            Principal peer = null;
            if (AsyncHTTPConduit.this.session != null) {
                cipherSuite = AsyncHTTPConduit.this.session.getCipherSuite();
                localCerts = AsyncHTTPConduit.this.session.getLocalCertificates();
                principal = AsyncHTTPConduit.this.session.getLocalPrincipal();
                serverCerts = AsyncHTTPConduit.this.session.getPeerCertificates();
                peer = AsyncHTTPConduit.this.session.getPeerPrincipal();
            }
            return new HttpsURLConnectionInfo(this.url, method, cipherSuite, localCerts, principal, serverCerts, peer);
        }

        @Override
        protected int getResponseCode() throws IOException {
            return this.getHttpResponse().getStatusLine().getStatusCode();
        }

        @Override
        protected String getResponseMessage() throws IOException {
            return this.getHttpResponse().getStatusLine().getReasonPhrase();
        }

        private String readHeaders(Headers h) throws IOException {
            Header[] headers = this.getHttpResponse().getAllHeaders();
            h.headerMap().clear();
            String ct = null;
            for (Header header : headers) {
                List<String> s = h.headerMap().get(header.getName());
                if (s == null) {
                    s = new ArrayList<String>(1);
                    h.headerMap().put(header.getName(), s);
                }
                s.add(header.getValue());
                if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                ct = header.getValue();
            }
            return ct;
        }

        @Override
        protected void updateResponseHeaders(Message inMessage) throws IOException {
            Headers h = new Headers(inMessage);
            inMessage.put("Content-Type", this.readHeaders(h));
            AsyncHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected InputStream getPartialResponse() throws IOException {
            InputStream in = null;
            int responseCode = this.getResponseCode();
            if (responseCode == 202 || responseCode == 200) {
                boolean isEofTerminated;
                Header head = this.httpResponse.getFirstHeader("Content-Length");
                int cli = 0;
                if (head != null) {
                    cli = Integer.parseInt(head.getValue());
                }
                boolean isChunked = (head = this.httpResponse.getFirstHeader("Transfer-Encoding")) != null && "chunked".equalsIgnoreCase(head.getValue());
                head = this.httpResponse.getFirstHeader("Connection");
                boolean bl = isEofTerminated = head != null && "close".equalsIgnoreCase(head.getValue());
                if (cli > 0) {
                    in = this.getInputStream();
                } else if (isChunked || isEofTerminated) {
                    try {
                        PushbackInputStream pin = new PushbackInputStream(this.getInputStream());
                        int c = pin.read();
                        if (c != -1) {
                            pin.unread((byte)c);
                            in = pin;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return in;
        }

        @Override
        protected void updateCookiesBeforeRetransmit() throws IOException {
            Headers h = new Headers();
            this.readHeaders(h);
            AsyncHTTPConduit.this.cookies.readFromHeaders(h);
        }

        @Override
        protected boolean authorizationRetransmit() throws IOException {
            boolean b = super.authorizationRetransmit();
            if (!b) {
                try {
                    this.closeInputStream();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                AsyncHTTPConduit.this.cookies.writeToMessageHeaders(this.outMessage);
                this.retransmit(this.url.toString());
                return true;
            }
            return b;
        }

        @Override
        protected void retransmitStream() throws IOException {
            this.cachingForRetransmission = false;
            this.setupWrappedStream();
            this.cachedStream.writeCacheTo(this.wrappedStream);
            this.wrappedStream.flush();
            this.wrappedStream.close();
        }

        @Override
        protected void setupNewConnection(String newURL) throws IOException {
            this.httpResponse = null;
            this.isAsync = this.outMessage != null && this.outMessage.getExchange() != null && !this.outMessage.getExchange().isSynchronous();
            this.exception = null;
            this.connectionFuture = null;
            AsyncHTTPConduit.this.session = null;
            AsyncHTTPConduit.this.sslState = null;
            AsyncHTTPConduit.this.sslURL = null;
            HeapByteBufferAllocator allocator = new HeapByteBufferAllocator();
            int bufSize = this.csPolicy.getChunkLength() > 0 ? this.csPolicy.getChunkLength() : 16320;
            this.inbuf = new SharedInputBuffer(bufSize, allocator);
            this.outbuf = new SharedOutputBuffer(bufSize, allocator);
            try {
                if (AsyncHTTPConduit.this.defaultAddress.getString().equals(newURL)) {
                    AsyncHTTPConduit.this.setupConnection(this.outMessage, AsyncHTTPConduit.this.defaultAddress, this.csPolicy);
                } else {
                    Address address = new Address(newURL);
                    this.url = address.getURI();
                    AsyncHTTPConduit.this.setupConnection(this.outMessage, address, this.csPolicy);
                }
                this.entity = this.outMessage.get(CXFHttpRequest.class);
                this.basicEntity = (BasicHttpEntity)this.entity.getEntity();
                this.entity.setOutputStream(this);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSSLSession(SSLSession sslsession) {
            AsyncHTTPConduit.this.session = sslsession;
            Object object = this.sessionLock;
            synchronized (object) {
                AsyncHTTPConduit.this.sslState = sslsession.getLocalPrincipal();
                AsyncHTTPConduit.this.sslURL = this.url;
                this.sessionLock.notifyAll();
            }
        }
    }
}

