/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.detection;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.PslUtils;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;

public class WmiDetectionService {
    @NonNull
    private IWinRequestExecutor winRequestExecutor;

    public CriterionTestResult performDetectionTest(String hostname, @NonNull IWinConfiguration winConfiguration, @NonNull WmiCriterion wmiCriterion) {
        List<List<String>> queryResult;
        if (winConfiguration == null) {
            throw new IllegalArgumentException("winConfiguration is marked non-null but is null");
        }
        if (wmiCriterion == null) {
            throw new IllegalArgumentException("wmiCriterion is marked non-null but is null");
        }
        try {
            queryResult = this.winRequestExecutor.executeWmi(hostname, winConfiguration, wmiCriterion.getQuery(), wmiCriterion.getNamespace());
        }
        catch (Exception e) {
            return CriterionTestResult.error((Criterion)wmiCriterion, (Throwable)e);
        }
        String actualResult = SourceTable.tableToCsv(queryResult, (String)";", (boolean)true);
        if (actualResult == null || actualResult.isBlank()) {
            return CriterionTestResult.failure((Criterion)wmiCriterion, (String)"No result.");
        }
        if (wmiCriterion.getExpectedResult() == null || wmiCriterion.getExpectedResult().isBlank()) {
            return CriterionTestResult.success((Criterion)wmiCriterion, (String)actualResult);
        }
        Matcher matcher = Pattern.compile(PslUtils.psl2JavaRegex((String)wmiCriterion.getExpectedResult()), 10).matcher(actualResult);
        if (matcher.find()) {
            return CriterionTestResult.success((Criterion)wmiCriterion, (String)matcher.group());
        }
        return CriterionTestResult.failure((Criterion)wmiCriterion, (String)actualResult);
    }

    @Generated
    public WmiDetectionService(@NonNull IWinRequestExecutor winRequestExecutor) {
        if (winRequestExecutor == null) {
            throw new IllegalArgumentException("winRequestExecutor is marked non-null but is null");
        }
        this.winRequestExecutor = winRequestExecutor;
    }

    @NonNull
    @Generated
    public IWinRequestExecutor getWinRequestExecutor() {
        return this.winRequestExecutor;
    }
}

