/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.win.source;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WmiSourceProcessor.class);
    @NonNull
    private IWinRequestExecutor winRequestExecutor;
    @NonNull
    private Function<TelemetryManager, IWinConfiguration> configurationRetriever;
    @NonNull
    private String connectorId;

    public SourceTable process(WmiSource wmiSource, TelemetryManager telemetryManager) {
        if (wmiSource == null) {
            log.warn("Hostname {} - Malformed WMI source {}. Returning an empty table.", (Object)telemetryManager.getHostname(), (Object)wmiSource);
            return SourceTable.empty();
        }
        IWinConfiguration winConfiguration = this.configurationRetriever.apply(telemetryManager);
        if (winConfiguration == null) {
            log.debug("Hostname {} - Neither WMI nor WinRM credentials are configured for this host. Returning an empty table for WMI source {}.", (Object)telemetryManager.getHostname(), (Object)wmiSource.getKey());
            return SourceTable.empty();
        }
        String hostname = telemetryManager.getHostname(List.of(winConfiguration.getClass()));
        String namespace = this.getNamespace(wmiSource, telemetryManager);
        if (namespace == null) {
            log.error("Hostname {} - Failed to retrieve the WMI namespace to run the WMI source {}. Returning an empty table.", (Object)hostname, (Object)wmiSource.getKey());
            return SourceTable.empty();
        }
        try {
            List<List<String>> table = this.winRequestExecutor.executeWmi(hostname, winConfiguration, wmiSource.getQuery(), namespace);
            return SourceTable.builder().table(table).build();
        }
        catch (Exception e) {
            LoggingHelper.logSourceError((String)this.connectorId, (String)wmiSource.getKey(), (String)String.format("WMI query=%s, Username=%s, Timeout=%d, Namespace=%s", wmiSource.getQuery(), winConfiguration.getUsername(), winConfiguration.getTimeout(), namespace), (String)hostname, (Throwable)e);
            return SourceTable.empty();
        }
    }

    String getNamespace(WmiSource wmiSource, TelemetryManager telemetryManager) {
        String sourceNamespace = wmiSource.getNamespace();
        if (sourceNamespace == null) {
            return "root\\cimv2";
        }
        if ("automatic".equalsIgnoreCase(sourceNamespace)) {
            return telemetryManager.getHostProperties().getConnectorNamespace(this.connectorId).getAutomaticWmiNamespace();
        }
        return sourceNamespace;
    }

    @Generated
    public WmiSourceProcessor(@NonNull IWinRequestExecutor winRequestExecutor, @NonNull Function<TelemetryManager, IWinConfiguration> configurationRetriever, @NonNull String connectorId) {
        if (winRequestExecutor == null) {
            throw new IllegalArgumentException("winRequestExecutor is marked non-null but is null");
        }
        if (configurationRetriever == null) {
            throw new IllegalArgumentException("configurationRetriever is marked non-null but is null");
        }
        if (connectorId == null) {
            throw new IllegalArgumentException("connectorId is marked non-null but is null");
        }
        this.winRequestExecutor = winRequestExecutor;
        this.configurationRetriever = configurationRetriever;
        this.connectorId = connectorId;
    }
}

