/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.winrm;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.TransportProtocols;
import org.sentrysoftware.metricshub.engine.deserialization.MultiValueDeserializer;
import org.sentrysoftware.metricshub.engine.deserialization.TimeDeserializer;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;

public class WinRmConfiguration
implements IWinConfiguration {
    private static final String WINRM_DESCRIPTION = "WinRm";
    private String username;
    private char[] password;
    private String namespace;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    private String hostname;
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer port;
    @JsonSetter(nulls=Nulls.SKIP)
    private TransportProtocols protocol;
    private List<AuthenticationEnum> authentications;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    private Long timeout;

    public void validateConfiguration(String resourceKey) throws InvalidConfigurationException {
        StringHelper.validateConfigurationAttribute((Object)this.port, attr -> attr == null || attr < 1 || attr > 65535, () -> String.format("Resource %s - Invalid port configured for protocol %s. Port value returned: %s. This resource will not be monitored. Please verify the configured port value.", resourceKey, WINRM_DESCRIPTION, this.port));
        StringHelper.validateConfigurationAttribute((Object)this.timeout, attr -> attr == null || attr < 0L, () -> String.format("Resource %s - Timeout value is invalid for protocol %s. Timeout value returned: %s. This resource will not be monitored. Please verify the configured timeout value.", resourceKey, WINRM_DESCRIPTION, this.timeout));
        StringHelper.validateConfigurationAttribute((Object)this.username, attr -> attr == null || attr.isBlank(), () -> String.format("Resource %s - No username configured for protocol %s. This resource will not be monitored. Please verify the configured username.", resourceKey, WINRM_DESCRIPTION));
    }

    public String toString() {
        Object desc = WINRM_DESCRIPTION;
        if (this.username != null) {
            desc = (String)desc + " as " + this.username;
        }
        return desc;
    }

    public IConfiguration copy() {
        return WinRmConfiguration.builder().authentications(new ArrayList<AuthenticationEnum>(this.authentications)).namespace(this.namespace).password(this.password).port(this.port).protocol(this.protocol).timeout(this.timeout).username(this.username).hostname(this.hostname).build();
    }

    @Generated
    private static Integer $default$port() {
        return 5985;
    }

    @Generated
    private static TransportProtocols $default$protocol() {
        return TransportProtocols.HTTP;
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static WinRmConfigurationBuilder builder() {
        return new WinRmConfigurationBuilder();
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public char[] getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public TransportProtocols getProtocol() {
        return this.protocol;
    }

    @Generated
    public List<AuthenticationEnum> getAuthentications() {
        return this.authentications;
    }

    @Override
    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=MultiValueDeserializer.class)
    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setProtocol(TransportProtocols protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setAuthentications(List<AuthenticationEnum> authentications) {
        this.authentications = authentications;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=TimeDeserializer.class)
    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WinRmConfiguration)) {
            return false;
        }
        WinRmConfiguration other = (WinRmConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        TransportProtocols this$protocol = this.getProtocol();
        TransportProtocols other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        List<AuthenticationEnum> this$authentications = this.getAuthentications();
        List<AuthenticationEnum> other$authentications = other.getAuthentications();
        return !(this$authentications == null ? other$authentications != null : !((Object)this$authentications).equals(other$authentications));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WinRmConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        TransportProtocols $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        List<AuthenticationEnum> $authentications = this.getAuthentications();
        result = result * 59 + ($authentications == null ? 43 : ((Object)$authentications).hashCode());
        return result;
    }

    @Generated
    public WinRmConfiguration(String username, char[] password, String namespace, String hostname, Integer port, TransportProtocols protocol, List<AuthenticationEnum> authentications, Long timeout) {
        this.username = username;
        this.password = password;
        this.namespace = namespace;
        this.hostname = hostname;
        this.port = port;
        this.protocol = protocol;
        this.authentications = authentications;
        this.timeout = timeout;
    }

    @Generated
    public WinRmConfiguration() {
        this.port = WinRmConfiguration.$default$port();
        this.protocol = WinRmConfiguration.$default$protocol();
        this.timeout = WinRmConfiguration.$default$timeout();
    }

    @Generated
    public static class WinRmConfigurationBuilder {
        @Generated
        private String username;
        @Generated
        private char[] password;
        @Generated
        private String namespace;
        @Generated
        private String hostname;
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private boolean protocol$set;
        @Generated
        private TransportProtocols protocol$value;
        @Generated
        private List<AuthenticationEnum> authentications;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;

        @Generated
        WinRmConfigurationBuilder() {
        }

        @Generated
        public WinRmConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public WinRmConfigurationBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        @Generated
        public WinRmConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=MultiValueDeserializer.class)
        @Generated
        public WinRmConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public WinRmConfigurationBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public WinRmConfigurationBuilder protocol(TransportProtocols protocol) {
            this.protocol$value = protocol;
            this.protocol$set = true;
            return this;
        }

        @Generated
        public WinRmConfigurationBuilder authentications(List<AuthenticationEnum> authentications) {
            this.authentications = authentications;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=TimeDeserializer.class)
        @Generated
        public WinRmConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public WinRmConfiguration build() {
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = WinRmConfiguration.$default$port();
            }
            TransportProtocols protocol$value = this.protocol$value;
            if (!this.protocol$set) {
                protocol$value = WinRmConfiguration.$default$protocol();
            }
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = WinRmConfiguration.$default$timeout();
            }
            return new WinRmConfiguration(this.username, this.password, this.namespace, this.hostname, port$value, protocol$value, this.authentications, timeout$value);
        }

        @Generated
        public String toString() {
            return "WinRmConfiguration.WinRmConfigurationBuilder(username=" + this.username + ", password=" + Arrays.toString(this.password) + ", namespace=" + this.namespace + ", hostname=" + this.hostname + ", port$value=" + this.port$value + ", protocol$value=" + String.valueOf(this.protocol$value) + ", authentications=" + String.valueOf(this.authentications) + ", timeout$value=" + this.timeout$value + ")";
        }
    }
}

