/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.extension.winrm;

import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.ClientException;
import org.sentrysoftware.metricshub.engine.common.helpers.LoggingHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.TransportProtocols;
import org.sentrysoftware.metricshub.extension.win.IWinConfiguration;
import org.sentrysoftware.metricshub.extension.win.IWinRequestExecutor;
import org.sentrysoftware.metricshub.extension.winrm.WinRmConfiguration;
import org.sentrysoftware.winrm.WinRMHttpProtocolEnum;
import org.sentrysoftware.winrm.WindowsRemoteCommandResult;
import org.sentrysoftware.winrm.command.WinRMCommandExecutor;
import org.sentrysoftware.winrm.exceptions.WindowsRemoteException;
import org.sentrysoftware.winrm.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;
import org.sentrysoftware.winrm.wql.WinRMWqlExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmRequestExecutor
implements IWinRequestExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WinRmRequestExecutor.class);

    @Override
    @WithSpan(value="WinRM")
    public List<List<String>> executeWmi(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="winrm.config") @NonNull IWinConfiguration winConfiguration, @SpanAttribute(value="winrm.query") @NonNull String query, @SpanAttribute(value="winrm.namespace") @NonNull String namespace) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (winConfiguration == null) {
            throw new IllegalArgumentException("winConfiguration is marked non-null but is null");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("namespace is marked non-null but is null");
        }
        if (!(winConfiguration instanceof WinRmConfiguration)) {
            throw new ClientException("Invalid WinRmConfiguration on " + hostname);
        }
        WinRmConfiguration winRmConfiguration = (WinRmConfiguration)winConfiguration;
        String username = winRmConfiguration.getUsername();
        WinRMHttpProtocolEnum httpProtocol = TransportProtocols.HTTP.equals((Object)winRmConfiguration.getProtocol()) ? WinRMHttpProtocolEnum.HTTP : WinRMHttpProtocolEnum.HTTPS;
        Integer port = winRmConfiguration.getPort();
        List<AuthenticationEnum> authentications = winRmConfiguration.getAuthentications();
        Long timeout = winRmConfiguration.getTimeout();
        LoggingHelper.trace(() -> log.trace("Executing WinRM WQL request:\n- hostname: {}\n- username: {}\n- query: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n- namespace: {}\n", new Object[]{hostname, username, query, httpProtocol, port, authentications, timeout, namespace}));
        try {
            long startTime = System.currentTimeMillis();
            WinRMWqlExecutor result = WinRMWqlExecutor.executeWql(httpProtocol, hostname, port, username, winRmConfiguration.getPassword(), namespace, query, timeout * 1000L, null, authentications);
            long responseTime = System.currentTimeMillis() - startTime;
            List<List<String>> table = result.getRows();
            LoggingHelper.trace(() -> log.trace("Executed WinRM WQL request:\n- hostname: {}\n- username: {}\n- query: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n- namespace: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, username, query, httpProtocol, port, authentications, timeout, namespace, TextTableHelper.generateTextTable((List)table), responseTime}));
            return table;
        }
        catch (Exception e) {
            log.error("Hostname {} - WinRM WQL request failed. Errors:\n{}\n", (Object)hostname, (Object)StringHelper.getStackMessages((Throwable)e));
            throw new ClientException(String.format("WinRM WQL request failed on %s.", hostname), e);
        }
    }

    @Override
    public boolean isAcceptableException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof WindowsRemoteException) {
            String message = t.getMessage();
            return IWinRequestExecutor.isAcceptableWmiComError(message);
        }
        if (t instanceof WqlQuerySyntaxException) {
            return true;
        }
        return this.isAcceptableException(t.getCause());
    }

    @Override
    public String executeWinRemoteCommand(String hostname, IWinConfiguration winConfiguration, String command, List<String> embeddedFiles) throws ClientException {
        if (winConfiguration instanceof WinRmConfiguration) {
            WinRmConfiguration winRmConfiguration = (WinRmConfiguration)winConfiguration;
            return WinRmRequestExecutor.executeRemoteWinRmCommand(hostname, winRmConfiguration, command);
        }
        throw new IllegalStateException("Windows commands can be executed only in WMI and WinRM protocols.");
    }

    @WithSpan(value="Remote Command WinRM")
    public static String executeRemoteWinRmCommand(@SpanAttribute(value="host.hostname") @NonNull String hostname, @SpanAttribute(value="winrm.config") @NonNull WinRmConfiguration winRmConfiguration, @SpanAttribute(value="winrm.command") @NonNull String command) throws ClientException {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (winRmConfiguration == null) {
            throw new IllegalArgumentException("winRmConfiguration is marked non-null but is null");
        }
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        String username = winRmConfiguration.getUsername();
        WinRMHttpProtocolEnum httpProtocol = TransportProtocols.HTTP.equals((Object)winRmConfiguration.getProtocol()) ? WinRMHttpProtocolEnum.HTTP : WinRMHttpProtocolEnum.HTTPS;
        Integer port = winRmConfiguration.getPort();
        List<AuthenticationEnum> authentications = winRmConfiguration.getAuthentications();
        Long timeout = winRmConfiguration.getTimeout();
        LoggingHelper.trace(() -> log.trace("Executing WinRM remote command:\n- hostname: {}\n- username: {}\n- command: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n", new Object[]{hostname, username, command, httpProtocol, port, authentications, timeout}));
        try {
            long startTime = System.currentTimeMillis();
            WindowsRemoteCommandResult result = WinRMCommandExecutor.execute(command, httpProtocol, hostname, port, username, winRmConfiguration.getPassword(), null, timeout * 1000L, null, null, authentications);
            long responseTime = System.currentTimeMillis() - startTime;
            if (result.getStatusCode() != 0) {
                throw new ClientException(String.format("WinRM remote command failed on %s: %s", hostname, result.getStderr()));
            }
            String resultStdout = result.getStdout();
            LoggingHelper.trace(() -> log.trace("Executed WinRM remote command:\n- hostname: {}\n- username: {}\n- command: {}\n- protocol: {}\n- port: {}\n- authentications: {}\n- timeout: {}\n- Result:\n{}\n- response-time: {}\n", new Object[]{hostname, username, command, httpProtocol, port, authentications, timeout, resultStdout, responseTime}));
            return resultStdout;
        }
        catch (Exception e) {
            log.error("Hostname {} - WinRM remote command failed. Errors:\n{}\n", (Object)hostname, (Object)StringHelper.getStackMessages((Throwable)e));
            throw new ClientException(String.format("WinRM remote command failed on %s.", hostname), e);
        }
    }
}

