/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduitFactory;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.WindowsRemoteCommandResult;
import org.sentrysoftware.winrm.WindowsRemoteExecutor;
import org.sentrysoftware.winrm.WmiHelper;
import org.sentrysoftware.winrm.exceptions.WinRMException;
import org.sentrysoftware.winrm.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.winrm.service.WinRMEndpoint;
import org.sentrysoftware.winrm.service.WinRMWebService;
import org.sentrysoftware.winrm.service.client.WinRMInvocationHandler;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;
import org.sentrysoftware.winrm.service.enumeration.Enumerate;
import org.sentrysoftware.winrm.service.enumeration.EnumerateResponse;
import org.sentrysoftware.winrm.service.enumeration.EnumerationContextType;
import org.sentrysoftware.winrm.service.enumeration.FilterType;
import org.sentrysoftware.winrm.service.enumeration.Pull;
import org.sentrysoftware.winrm.service.enumeration.PullResponse;
import org.sentrysoftware.winrm.service.shell.CommandLine;
import org.sentrysoftware.winrm.service.shell.CommandStateType;
import org.sentrysoftware.winrm.service.shell.DesiredStreamType;
import org.sentrysoftware.winrm.service.shell.Receive;
import org.sentrysoftware.winrm.service.shell.ReceiveResponse;
import org.sentrysoftware.winrm.service.shell.Shell;
import org.sentrysoftware.winrm.service.shell.StreamType;
import org.sentrysoftware.winrm.service.transfer.ResourceCreated;
import org.sentrysoftware.winrm.service.wsman.AnyListType;
import org.sentrysoftware.winrm.service.wsman.CommandResponse;
import org.sentrysoftware.winrm.service.wsman.Delete;
import org.sentrysoftware.winrm.service.wsman.Locale;
import org.sentrysoftware.winrm.service.wsman.MixedDataType;
import org.sentrysoftware.winrm.service.wsman.OptionSetType;
import org.sentrysoftware.winrm.service.wsman.OptionType;
import org.sentrysoftware.winrm.service.wsman.SelectorSetType;
import org.sentrysoftware.winrm.service.wsman.SelectorType;
import org.sentrysoftware.winrm.service.wsman.Signal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WinRMService
implements WindowsRemoteExecutor {
    public static final List<AuthenticationEnum> DEFAULT_AUTHENTICATION = Collections.singletonList(AuthenticationEnum.NTLM);
    private static final String STDERR = "stderr";
    private static final String STDOUT = "stdout";
    private static final int MAX_ENVELOPE_SIZE = 153600;
    private static final String ENUMERATION_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/09/enumeration";
    private static final String WSMAN_URI = "http://schemas.microsoft.com/wbem/wsman/1";
    private static final String DIALECT_WQL = "http://schemas.microsoft.com/wbem/wsman/1/WQL";
    private static final String SHELL_URI = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell";
    private static final String COMMAND_RESOURCE_URI = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd";
    private static final String COMMAND_STATE_DONE = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/CommandState/Done";
    private static final String TERMINATE_CODE = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/signal/terminate";
    private static final QName WSEN_ITEMS_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/enumeration", "Items");
    private static final QName WSMAN_ITEMS_QNAME = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "Items");
    private static final QName WSMAN_END_OF_SEQUENCE_QNAME = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "EndOfSequence");
    private static final QName WSEN_END_OF_SEQUENCE_QNAME = new QName("http://schemas.xmlsoap.org/ws/2004/09/enumeration", "EndOfSequence");
    private static final QName WSMAN_XML_FRAGMENT_QNAME = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "XmlFragment");
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final String WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED = "2150858793";
    private static final String WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND = "2150858843";
    private static final Locale LOCALE = new Locale();
    private static final OptionSetType OPTION_SET_CREATE;
    private static final OptionSetType OPTION_SET_COMMAND;
    private static final ConcurrentHashMap<WinRMEndpoint, WinRMService> CONNECTIONS_CACHE;
    private final AtomicInteger useCount = new AtomicInteger(1);
    private final WinRMEndpoint winRMEndpoint;
    private final Bus bus;
    private final WinRMWebService cmdWS;
    private final WinRMWebService wqlWS;
    private final Client cmdClient;
    private final Client wqlClient;
    private final String strTimeout;
    private SelectorSetType shellSelector = null;

    private WinRMService(WinRMEndpoint winRMEndpoint, Bus bus, WinRMInvocationHandler cmdInvocation, WinRMInvocationHandler wqlInvocation, long timeout) {
        this.winRMEndpoint = winRMEndpoint;
        this.bus = bus;
        this.cmdWS = WinRMService.createProxyService(cmdInvocation);
        this.wqlWS = WinRMService.createProxyService(wqlInvocation);
        this.cmdClient = cmdInvocation.getClient();
        this.wqlClient = wqlInvocation.getClient();
        BigDecimal timeoutSec = BigDecimal.valueOf(timeout).divide(BigDecimal.valueOf(1000L));
        DecimalFormat decimalFormat = new DecimalFormat("PT#.###S", new DecimalFormatSymbols(java.util.Locale.ROOT));
        this.strTimeout = decimalFormat.format(timeoutSec);
    }

    public static WinRMService createInstance(WinRMEndpoint winRMEndpoint, long timeout, Path ticketCache, List<AuthenticationEnum> authentications) throws WinRMException {
        Utils.checkNonNull(winRMEndpoint, "winRMEndpoint");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        List<AuthenticationEnum> normalizedAuthentications = authentications == null ? DEFAULT_AUTHENTICATION : authentications.stream().distinct().collect(Collectors.toList());
        try {
            return CONNECTIONS_CACHE.compute(winRMEndpoint, (key, win) -> {
                if (win == null) {
                    Bus bus = BusFactory.newInstance().createBus();
                    bus.getProperties().put("use.async.http.conduit", Boolean.TRUE);
                    bus.getProperties().put("org.apache.cxf.transport.http.async.usePolicy", (Object)AsyncHTTPConduitFactory.UseAsyncPolicy.ALWAYS);
                    WinRMInvocationHandler cmdInvocation = WinRMService.createWinRMInvocationHandlerInstance(winRMEndpoint, bus, timeout, null, ticketCache, normalizedAuthentications);
                    WinRMInvocationHandler wqlInvocation = WinRMService.createWinRMInvocationHandlerInstance(winRMEndpoint, bus, timeout, String.format("%s/wmi/%s/*", WSMAN_URI, winRMEndpoint.getNamespace()), ticketCache, normalizedAuthentications);
                    return new WinRMService(winRMEndpoint, bus, cmdInvocation, wqlInvocation, timeout);
                }
                WinRMService winRMService = win;
                synchronized (winRMService) {
                    win.incrementUseCount();
                    return win;
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() != null) {
                String message = e.getMessage() != null ? String.format("%s\n%s: %s", e.getMessage(), e.getCause().getClass().getSimpleName(), e.getCause().getMessage()) : String.format("%s: %s", e.getCause().getClass().getSimpleName(), e.getCause().getMessage());
                throw new WinRMException(e.getCause(), message);
            }
            throw new WinRMException(e.getMessage());
        }
    }

    public int getUseCount() {
        return this.useCount.get();
    }

    public boolean isConnected() {
        return this.getUseCount() > 0;
    }

    void incrementUseCount() {
        this.useCount.incrementAndGet();
    }

    public void checkConnectedFirst() {
        if (!this.isConnected()) {
            throw new IllegalStateException("This instance has been closed and a new one must be created.");
        }
    }

    @Override
    public void close() {
        if (this.useCount.decrementAndGet() == 0) {
            CONNECTIONS_CACHE.remove(this.winRMEndpoint);
            if (this.shellSelector != null) {
                this.cmdWS.delete(new Delete(), COMMAND_RESOURCE_URI, 153600, this.strTimeout, LOCALE, this.shellSelector);
                this.shellSelector = null;
            }
            if (this.cmdClient != null) {
                this.cmdClient.destroy();
            }
            if (this.wqlClient != null) {
                this.wqlClient.destroy();
            }
            if (this.bus != null && this.bus.getState() != Bus.BusState.SHUTDOWN) {
                this.bus.shutdown(true);
            }
        }
    }

    @Override
    public WindowsRemoteCommandResult executeCommand(String command, String workingDirectory, Charset charset, long timeout) throws WinRMException, TimeoutException {
        Utils.checkNonNull(command, "command");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        this.checkConnectedFirst();
        try {
            return Utils.execute(() -> {
                if (this.getShellSelector() == null) {
                    this.create(workingDirectory);
                }
                try {
                    StringWriter stdout = new StringWriter();
                    StringWriter stderr = new StringWriter();
                    Charset cs = charset != null ? charset : StandardCharsets.UTF_8;
                    long start = Utils.getCurrentTimeMillis();
                    int statusCode = this.execute(command, stdout, stderr, cs);
                    float executionTime = (float)(Utils.getCurrentTimeMillis() - start) / 1000.0f;
                    return new WindowsRemoteCommandResult(stdout.toString(), stderr.toString(), executionTime, statusCode);
                }
                catch (WinRMException e) {
                    throw new RuntimeException(e);
                }
            }, timeout);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() != null) {
                throw new WinRMException(e.getCause(), e.getCause().getMessage());
            }
            throw new WinRMException(e);
        }
    }

    @Override
    public List<Map<String, Object>> executeWql(String wqlQuery, long timeout) throws WinRMException, WqlQuerySyntaxException, TimeoutException {
        Utils.checkNonNull(wqlQuery, "wqlQuery");
        if (!WmiHelper.isValidWql(wqlQuery)) {
            throw new WqlQuerySyntaxException(wqlQuery);
        }
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        this.checkConnectedFirst();
        try {
            return Utils.execute(() -> {
                ArrayList<Node> nodes = new ArrayList<Node>();
                EnumerateResponse enumerateResponse = this.enumerate(wqlQuery);
                boolean endOfSequence = this.getItemsFrom(enumerateResponse, nodes);
                if (!endOfSequence) {
                    String nextContextId = this.getContextIdFrom(enumerateResponse.getEnumerationContext());
                    this.pull(nextContextId, nodes);
                }
                return nodes.stream().map(WinRMService::convertRow).collect(Collectors.toList());
            }, timeout);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() != null) {
                throw new WinRMException(e.getCause(), e.getCause().getMessage());
            }
            throw new WinRMException(e);
        }
    }

    public static WinRMInvocationHandler createWinRMInvocationHandlerInstance(WinRMEndpoint winRMEndpoint, Bus bus, long timeout, String resourceUri, Path ticketCache, List<AuthenticationEnum> authentications) {
        return new WinRMInvocationHandler(winRMEndpoint, bus, timeout, resourceUri, ticketCache, authentications);
    }

    private static WinRMWebService createProxyService(WinRMInvocationHandler winRMInvocationHandler) {
        return (WinRMWebService)Proxy.newProxyInstance(WinRMWebService.class.getClassLoader(), new Class[]{WinRMWebService.class, BindingProvider.class}, (InvocationHandler)winRMInvocationHandler);
    }

    public EnumerateResponse enumerate(String wqlQuery) {
        FilterType filterType = new FilterType();
        filterType.setDialect(DIALECT_WQL);
        filterType.getContent().add(wqlQuery);
        Enumerate body = new Enumerate();
        body.setFilter(filterType);
        return this.wqlWS.enumerate(body);
    }

    public String pull(String contextId, List<Node> nodes) throws WinRMException {
        EnumerationContextType enumContext = new EnumerationContextType();
        enumContext.getContent().add(contextId);
        Pull body = new Pull();
        body.setEnumerationContext(enumContext);
        PullResponse response = this.wqlWS.pull(body);
        if (response == null) {
            throw new WinRMException(String.format("Pull failed for context id: %s", contextId));
        }
        boolean endOfSequence = WinRMService.getItemsFrom(response, nodes);
        String nextContextId = response.getEnumerationContext() == null ? null : this.getContextIdFrom(response.getEnumerationContext());
        return endOfSequence ? nextContextId : this.pull(nextContextId, nodes);
    }

    public ResourceCreated create(String workingDirectory) {
        Shell shell = new Shell();
        shell.getInputStreams().add("stdin");
        shell.getOutputStreams().add(STDOUT);
        shell.getOutputStreams().add(STDERR);
        if (Utils.isNotBlank(workingDirectory)) {
            shell.setWorkingDirectory(workingDirectory);
        }
        ResourceCreated resourceCreated = this.cmdWS.create(shell, COMMAND_RESOURCE_URI, 153600, this.strTimeout, LOCALE, OPTION_SET_CREATE);
        String shellId = WinRMService.getShellId(resourceCreated);
        this.shellSelector = new SelectorSetType();
        SelectorType selectorType = new SelectorType();
        selectorType.setName("ShellId");
        selectorType.getContent().add(shellId);
        this.shellSelector.getSelector().add(selectorType);
        return resourceCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String command, Writer out, Writer err, Charset charset) throws WinRMException {
        CommandLine body = new CommandLine();
        body.setCommand(command);
        CommandResponse commandResponse = this.cmdWS.command(body, COMMAND_RESOURCE_URI, 153600, this.strTimeout, LOCALE, this.shellSelector, OPTION_SET_COMMAND);
        String commandId = commandResponse.getCommandId();
        try {
            int n = this.receiveCommand(commandId, out, err, charset);
            return n;
        }
        finally {
            try {
                Signal signal = new Signal();
                signal.setCommandId(commandId);
                signal.setCode(TERMINATE_CODE);
                this.cmdWS.signal(signal, COMMAND_RESOURCE_URI, 153600, this.strTimeout, LOCALE, this.shellSelector);
            }
            catch (SOAPFaultException soapFault) {
                WinRMService.assertFaultCode(soapFault, WSMAN_FAULT_CODE_SHELL_WAS_NOT_FOUND, true);
            }
        }
    }

    private int receiveCommand(String commandId, Writer out, Writer err, Charset charset) throws WinRMException {
        while (true) {
            DesiredStreamType stream = new DesiredStreamType();
            stream.setCommandId(commandId);
            stream.setValue("stdout stderr");
            Receive receive = new Receive();
            receive.setDesiredStream(stream);
            try {
                ReceiveResponse receiveResponse = this.cmdWS.receive(receive, COMMAND_RESOURCE_URI, 153600, this.strTimeout, LOCALE, this.shellSelector);
                this.getStreams(receiveResponse, out, err, charset);
                CommandStateType state = receiveResponse.getCommandState();
                if (!COMMAND_STATE_DONE.equals(state.getState())) continue;
                return state.getExitCode().intValue();
            }
            catch (SOAPFaultException soapFault) {
                WinRMService.assertFaultCode(soapFault, WSMAN_FAULT_CODE_OPERATION_TIMEOUT_EXPIRED, false);
                continue;
            }
            break;
        }
    }

    private static Map<String, Object> convertRow(Node node) {
        return IntStream.range(0, node.getChildNodes().getLength()).mapToObj(node.getChildNodes()::item).filter(Objects::nonNull).collect(HashMap::new, (map, child) -> map.put(child.getLocalName(), child.getTextContent()), HashMap::putAll);
    }

    private static String getShellId(ResourceCreated resourceCreated) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Element element : resourceCreated.getAny()) {
            try {
                String shellId = xpath.evaluate("//*[local-name()='Selector' and @Name='ShellId']", element);
                if (shellId == null || shellId.isEmpty()) continue;
                return shellId;
            }
            catch (XPathExpressionException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Shell ID not fount in " + resourceCreated);
    }

    private static void assertFaultCode(SOAPFaultException soapFault, String code, boolean retry) {
        try {
            NodeList faultDetails = soapFault.getFault().getDetail().getChildNodes();
            for (int i = 0; i < faultDetails.getLength(); ++i) {
                Node item = faultDetails.item(i);
                if (!"WSManFault".equals(item.getLocalName())) continue;
                if (retry && code.equals(item.getAttributes().getNamedItem("Code").getNodeValue())) {
                    return;
                }
                throw soapFault;
            }
            throw soapFault;
        }
        catch (NullPointerException e) {
            throw soapFault;
        }
    }

    private void getStreams(ReceiveResponse receiveResponse, Writer out, Writer err, Charset charset) throws WinRMException {
        List<StreamType> streams = receiveResponse.getStream();
        for (StreamType streamType : streams) {
            byte[] value = streamType.getValue();
            if (value == null) continue;
            this.writeStd(out, STDOUT, streamType, value, charset);
            this.writeStd(err, STDERR, streamType, value, charset);
        }
    }

    private void writeStd(Writer std, String name, StreamType streamType, byte[] value, Charset charset) throws WinRMException {
        if (std == null || !name.equals(streamType.getName())) {
            return;
        }
        try {
            if (value.length > 0) {
                std.write(new String(value, charset));
                std.flush();
            }
            if (streamType.isEnd() != null && streamType.isEnd().booleanValue()) {
                std.close();
            }
        }
        catch (IOException e) {
            throw new WinRMException(e);
        }
    }

    public boolean getItemsFrom(EnumerateResponse response, List<Node> items) throws WinRMException {
        for (Object object : response.getAny()) {
            if (object instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)object;
                if (WSEN_ITEMS_QNAME.equals(jaxbElement.getName()) || WSMAN_ITEMS_QNAME.equals(jaxbElement.getName())) {
                    if (jaxbElement.isNil()) continue;
                    if (jaxbElement.getValue() instanceof AnyListType) {
                        AnyListType itemList = (AnyListType)jaxbElement.getValue();
                        for (Object item : itemList.getAny()) {
                            Node node = WinRMService.toNode(item).orElseThrow(() -> new WinRMException("Unsupported element of type %s in EnumerateResponse: %s", object.getClass(), object));
                            items.add(node);
                        }
                        continue;
                    }
                    throw new WinRMException("Unsupported value in EnumerateResponse Items: %s of type: %s", jaxbElement.getValue(), jaxbElement.getValue().getClass());
                }
                if (WSEN_END_OF_SEQUENCE_QNAME.equals(jaxbElement.getName()) || WSMAN_END_OF_SEQUENCE_QNAME.equals(jaxbElement.getName())) {
                    return true;
                }
                throw new WinRMException("Unsupported element in EnumerateResponse: %s with name: %s", jaxbElement, jaxbElement.getName());
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                if (WSEN_END_OF_SEQUENCE_QNAME.getNamespaceURI().equals(node.getNamespaceURI()) && WSEN_END_OF_SEQUENCE_QNAME.getLocalPart().equals(node.getLocalName()) || WSMAN_END_OF_SEQUENCE_QNAME.getNamespaceURI().equals(node.getNamespaceURI()) && WSMAN_END_OF_SEQUENCE_QNAME.getLocalPart().equals(node.getLocalName())) {
                    return true;
                }
                throw new WinRMException("Unsupported node in EnumerateResponse: %s with namespace: %s", node.toString(), node.getNamespaceURI());
            }
            throw new WinRMException("Unsupported element in EnumerateResponse: %s, with type: %s", object, object != null ? object.getClass() : null);
        }
        return false;
    }

    private static boolean getItemsFrom(PullResponse response, List<Node> items) throws WinRMException {
        for (Object item : response.getItems().getAny()) {
            Node node = WinRMService.toNode(item).orElseThrow(() -> new WinRMException("The pull response contains an unsupported item %s of type %s", item, item != null ? item.getClass() : null));
            items.add(node);
        }
        return response.getEndOfSequence() != null;
    }

    private static Optional<Node> toNode(Object item) throws WinRMException {
        JAXBElement nestedElement;
        if (item instanceof Node) {
            return Optional.of((Node)item);
        }
        if (item instanceof JAXBElement && WSMAN_XML_FRAGMENT_QNAME.equals((nestedElement = (JAXBElement)item).getName()) && !nestedElement.isNil() && nestedElement.getValue() instanceof MixedDataType) {
            Document document = WinRMService.createNewDocument();
            Element rootElement = document.createElementNS(WSMAN_XML_FRAGMENT_QNAME.getNamespaceURI(), WSMAN_XML_FRAGMENT_QNAME.getLocalPart());
            document.appendChild(rootElement);
            MixedDataType mixed = (MixedDataType)nestedElement.getValue();
            for (Object nestedItem : mixed.getContent()) {
                if (nestedItem instanceof String) continue;
                if (nestedItem instanceof Node) {
                    Node nestedNode = document.importNode((Node)nestedItem, true);
                    rootElement.appendChild(nestedNode);
                    continue;
                }
                throw new WinRMException("Unsupported element of type %s in XmlFragment: %s", nestedItem.getClass(), nestedItem);
            }
            return Optional.of(rootElement);
        }
        return Optional.empty();
    }

    private static Document createNewDocument() throws WinRMException {
        DocumentBuilderFactory documentBuilderFactory = DOCUMENT_BUILDER_FACTORY;
        synchronized (documentBuilderFactory) {
            try {
                return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new WinRMException(e);
            }
        }
    }

    public String getContextIdFrom(EnumerationContextType context) throws WinRMException {
        if (context == null || context.getContent() == null) {
            throw new WinRMException("EnumerationContext %s has no content.", context);
        }
        if (context.getContent().isEmpty()) {
            return null;
        }
        if (context.getContent().size() == 1) {
            Object content = context.getContent().get(0);
            if (content instanceof String) {
                return (String)content;
            }
            throw new WinRMException("Unsupported EnumerationContext content: %s", content);
        }
        throw new WinRMException("EnumerationContext contains too many elements, expected: 1 actual: %d", context.getContent().size());
    }

    public SelectorSetType getShellSelector() {
        return this.shellSelector;
    }

    @Override
    public String getHostname() {
        return this.winRMEndpoint.getHostname();
    }

    @Override
    public String getUsername() {
        return this.winRMEndpoint.getRawUsername();
    }

    @Override
    public char[] getPassword() {
        return this.winRMEndpoint.getPassword();
    }

    static {
        LOCALE.setLang(java.util.Locale.US.toLanguageTag());
        OptionType optNoProfile = new OptionType();
        optNoProfile.setName("WINRS_NOPROFILE");
        optNoProfile.setValue("true");
        OptionType optCodepage = new OptionType();
        optCodepage.setName("WINRS_CODEPAGE");
        optCodepage.setValue("437");
        OPTION_SET_CREATE = new OptionSetType();
        OPTION_SET_CREATE.getOption().add(optNoProfile);
        OPTION_SET_CREATE.getOption().add(optCodepage);
        OptionType optConsoleModeStdin = new OptionType();
        optConsoleModeStdin.setName("WINRS_CONSOLEMODE_STDIN");
        optConsoleModeStdin.setValue("true");
        OptionType optSkipCmdShell = new OptionType();
        optSkipCmdShell.setName("WINRS_SKIP_CMD_SHELL");
        optSkipCmdShell.setValue("false");
        OPTION_SET_COMMAND = new OptionSetType();
        OPTION_SET_COMMAND.getOption().add(optConsoleModeStdin);
        OPTION_SET_COMMAND.getOption().add(optSkipCmdShell);
        CONNECTIONS_CACHE = new ConcurrentHashMap();
    }
}

