/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private final String username;
    private final char[] password;

    public UsernamePasswordCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unknown Callback");
        }
    }
}

