/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.auth.NTCredentials;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NtlmKeys;
import org.sentrysoftware.winrm.service.client.auth.ntlm.Type3Message;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionAwareHttpEntity;
import org.sentrysoftware.winrm.service.client.encryption.EncryptionUtils;

public class NTCredentialsWithEncryption
extends NTCredentials {
    private static final long serialVersionUID = 1L;
    private boolean isAuthenticated = false;
    private long negotiateFlags;
    private byte[] clientSigningKey;
    private byte[] serverSigningKey;
    private byte[] clientSealingKey;
    private byte[] serverSealingKey;
    private AtomicLong sequenceNumberIncoming = new AtomicLong(-1L);
    private AtomicLong sequenceNumberOutgoing = new AtomicLong(-1L);
    private transient Cipher encryptor;
    private transient Cipher decryptor;

    public NTCredentialsWithEncryption(String userName, String password, String workstation, String domain) {
        super(userName, password, workstation, domain);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public void setClientSigningKey(byte[] clientSigningKey) {
        this.clientSigningKey = clientSigningKey;
    }

    public void setServerSigningKey(byte[] serverSigningKey) {
        this.serverSigningKey = serverSigningKey;
    }

    public byte[] getClientSigningKey() {
        return this.clientSigningKey;
    }

    public byte[] getServerSigningKey() {
        return this.serverSigningKey;
    }

    public void setClientSealingKey(byte[] clientSealingKey) {
        this.clientSealingKey = clientSealingKey;
    }

    public void setServerSealingKey(byte[] serverSealingKey) {
        this.serverSealingKey = serverSealingKey;
    }

    public byte[] getClientSealingKey() {
        return this.clientSealingKey;
    }

    public byte[] getServerSealingKey() {
        return this.serverSealingKey;
    }

    public long getNegotiateFlags() {
        return this.negotiateFlags;
    }

    public boolean hasNegotiateFlag(long flag) {
        return (this.getNegotiateFlags() & flag) == flag;
    }

    public void setNegotiateFlags(long negotiateFlags) {
        this.negotiateFlags = negotiateFlags;
    }

    public AtomicLong getSequenceNumberIncoming() {
        return this.sequenceNumberIncoming;
    }

    public AtomicLong getSequenceNumberOutgoing() {
        return this.sequenceNumberOutgoing;
    }

    public Cipher getStatefulEncryptor() {
        if (this.encryptor == null) {
            this.encryptor = EncryptionUtils.arc4(this.getClientSealingKey());
        }
        return this.encryptor;
    }

    public Cipher getStatefulDecryptor() {
        if (this.decryptor == null) {
            this.decryptor = EncryptionUtils.arc4(this.getServerSealingKey());
        }
        return this.decryptor;
    }

    void resetEncryption(HttpRequest request) {
        this.setIsAuthenticated(false);
        this.clientSealingKey = null;
        this.clientSigningKey = null;
        this.serverSealingKey = null;
        this.serverSigningKey = null;
        this.encryptor = null;
        this.decryptor = null;
        this.sequenceNumberIncoming.set(-1L);
        this.sequenceNumberOutgoing.set(-1L);
        if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() instanceof EncryptionAwareHttpEntity) {
            ((EncryptionAwareHttpEntity)((HttpEntityEnclosingRequest)request).getEntity()).refreshHeaders((HttpEntityEnclosingRequest)request);
        }
    }

    void initEncryption(Type3Message signAndSealData, HttpRequest request) {
        this.setIsAuthenticated(true);
        if (signAndSealData != null && signAndSealData.getExportedSessionKey() != null) {
            new NtlmKeys(signAndSealData).apply(this);
        }
        if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() instanceof EncryptionAwareHttpEntity) {
            ((EncryptionAwareHttpEntity)((HttpEntityEnclosingRequest)request).getEntity()).refreshHeaders((HttpEntityEnclosingRequest)request);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + super.toString() + "{auth=" + this.isAuthenticated() + "}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.clientSealingKey);
        result = 31 * result + Arrays.hashCode(this.clientSigningKey);
        result = 31 * result + Arrays.hashCode(this.serverSealingKey);
        result = 31 * result + Arrays.hashCode(this.serverSigningKey);
        result = 31 * result + Objects.hash(this.isAuthenticated, this.negotiateFlags, this.sequenceNumberIncoming, this.sequenceNumberOutgoing);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NTCredentialsWithEncryption)) {
            return false;
        }
        NTCredentialsWithEncryption other = (NTCredentialsWithEncryption)obj;
        return Arrays.equals(this.clientSealingKey, other.clientSealingKey) && Arrays.equals(this.clientSigningKey, other.clientSigningKey) && this.isAuthenticated == other.isAuthenticated && this.negotiateFlags == other.negotiateFlags && Objects.equals(this.sequenceNumberIncoming, other.sequenceNumberIncoming) && Objects.equals(this.sequenceNumberOutgoing, other.sequenceNumberOutgoing) && Arrays.equals(this.serverSealingKey, other.serverSealingKey) && Arrays.equals(this.serverSigningKey, other.serverSigningKey);
    }
}

