/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import java.util.Locale;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineImpl;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngineUtils;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMMessage;

class Type1Message
extends NTLMMessage {
    private final byte[] hostBytes;
    private final byte[] domainBytes;
    private final int flags;

    Type1Message(String domain, String host, Integer flags) {
        this.flags = flags == null ? Type1Message.getDefaultFlags() : flags;
        String unqualifiedHost = NTLMEngineImpl.convertHost(host);
        String unqualifiedDomain = NTLMEngineImpl.convertDomain(domain);
        this.hostBytes = unqualifiedHost != null ? unqualifiedHost.getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED) : null;
        this.domainBytes = unqualifiedDomain != null ? unqualifiedDomain.toUpperCase(Locale.ROOT).getBytes(NTLMEngineUtils.UNICODE_LITTLE_UNMARKED) : null;
    }

    static int getDefaultFlags() {
        return -1576500735;
    }

    @Override
    protected void buildMessage() {
        int domainBytesLength = 0;
        if (this.domainBytes != null) {
            domainBytesLength = this.domainBytes.length;
        }
        int hostBytesLength = 0;
        if (this.hostBytes != null) {
            hostBytesLength = this.hostBytes.length;
        }
        int finalLength = 40 + hostBytesLength + domainBytesLength;
        this.prepareResponse(finalLength, 1);
        this.addULong(this.flags);
        this.addUShort(domainBytesLength);
        this.addUShort(domainBytesLength);
        this.addULong(hostBytesLength + 32 + 8);
        this.addUShort(hostBytesLength);
        this.addUShort(hostBytesLength);
        this.addULong(40);
        this.addUShort(261);
        this.addULong(2600);
        this.addUShort(3840);
        if (this.hostBytes != null) {
            this.addBytes(this.hostBytes);
        }
        if (this.domainBytes != null) {
            this.addBytes(this.domainBytes);
        }
    }
}

