/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    private static final String HMAC_MD5 = "HmacMD5";
    private static final String RC4 = "RC4";

    private EncryptionUtils() {
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("MD5 message digest doesn't seem to exist - fatal error: " + ex.getMessage(), ex);
        }
    }

    public static byte[] md5digest(byte[] bytes) {
        MessageDigest handle = EncryptionUtils.getMD5();
        handle.update(bytes);
        return handle.digest();
    }

    public static Cipher arc4(byte[] key) {
        try {
            Cipher rc4 = Cipher.getInstance(RC4);
            rc4.init(1, new SecretKeySpec(key, RC4));
            return rc4;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] calculateRC4(byte[] value, byte[] key) {
        try {
            return EncryptionUtils.arc4(key).doFinal(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] hmacMd5(byte[] key, byte[] body) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, HMAC_MD5);
            Mac mac = Mac.getInstance(HMAC_MD5);
            mac.init(keySpec);
            return mac.doFinal(body);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

