/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import org.glassfish.json.JsonTokenizer;

final class JsonMessages {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.glassfish.json.messages");

    JsonMessages() {
    }

    static String TOKENIZER_UNEXPECTED_CHAR(int unexpected, JsonLocation location) {
        return JsonMessages.localize("tokenizer.unexpected.char", unexpected, location);
    }

    static String TOKENIZER_EXPECTED_CHAR(int unexpected, JsonLocation location, char expected) {
        return JsonMessages.localize("tokenizer.expected.char", unexpected, location, Character.valueOf(expected));
    }

    static String TOKENIZER_IO_ERR() {
        return JsonMessages.localize("tokenizer.io.err", new Object[0]);
    }

    static String PARSER_GETSTRING_ERR(JsonParser.Event event) {
        return JsonMessages.localize("parser.getString.err", new Object[]{event});
    }

    static String PARSER_ISINTEGRALNUMBER_ERR(JsonParser.Event event) {
        return JsonMessages.localize("parser.isIntegralNumber.err", new Object[]{event});
    }

    static String PARSER_GETINT_ERR(JsonParser.Event event) {
        return JsonMessages.localize("parser.getInt.err", new Object[]{event});
    }

    static String PARSER_GETLONG_ERR(JsonParser.Event event) {
        return JsonMessages.localize("parser.getLong.err", new Object[]{event});
    }

    static String PARSER_GETBIGDECIMAL_ERR(JsonParser.Event event) {
        return JsonMessages.localize("parser.getBigDecimal.err", new Object[]{event});
    }

    static String PARSER_EXPECTED_EOF(JsonTokenizer.JsonToken token) {
        return JsonMessages.localize("parser.expected.eof", new Object[]{token});
    }

    static String PARSER_TOKENIZER_CLOSE_IO() {
        return JsonMessages.localize("parser.tokenizer.close.io", new Object[0]);
    }

    static String PARSER_INVALID_TOKEN(JsonTokenizer.JsonToken token, JsonLocation location, String expectedTokens) {
        return JsonMessages.localize("parser.invalid.token", new Object[]{token, location, expectedTokens});
    }

    static String GENERATOR_FLUSH_IO_ERR() {
        return JsonMessages.localize("generator.flush.io.err", new Object[0]);
    }

    static String GENERATOR_CLOSE_IO_ERR() {
        return JsonMessages.localize("generator.close.io.err", new Object[0]);
    }

    static String GENERATOR_WRITE_IO_ERR() {
        return JsonMessages.localize("generator.write.io.err", new Object[0]);
    }

    static String GENERATOR_ILLEGAL_METHOD(Object scope) {
        return JsonMessages.localize("generator.illegal.method", scope);
    }

    static String GENERATOR_DOUBLE_INFINITE_NAN() {
        return JsonMessages.localize("generator.double.infinite.nan", new Object[0]);
    }

    static String GENERATOR_INCOMPLETE_JSON() {
        return JsonMessages.localize("generator.incomplete.json", new Object[0]);
    }

    static String GENERATOR_ILLEGAL_MULTIPLE_TEXT() {
        return JsonMessages.localize("generator.illegal.multiple.text", new Object[0]);
    }

    static String WRITER_WRITE_ALREADY_CALLED() {
        return JsonMessages.localize("writer.write.already.called", new Object[0]);
    }

    static String READER_READ_ALREADY_CALLED() {
        return JsonMessages.localize("reader.read.already.called", new Object[0]);
    }

    static String READER_EXPECTED_ARRAY_GOT_OBJECT() {
        return JsonMessages.localize("reader.expected.array.got.object", new Object[0]);
    }

    static String READER_EXPECTED_OBJECT_GOT_ARRAY() {
        return JsonMessages.localize("reader.expected.object.got.array", new Object[0]);
    }

    static String OBJBUILDER_NAME_NULL() {
        return JsonMessages.localize("objbuilder.name.null", new Object[0]);
    }

    static String OBJBUILDER_VALUE_NULL() {
        return JsonMessages.localize("objbuilder.value.null", new Object[0]);
    }

    static String OBJBUILDER_OBJECT_BUILDER_NULL() {
        return JsonMessages.localize("objbuilder.object.builder.null", new Object[0]);
    }

    static String OBJBUILDER_ARRAY_BUILDER_NULL() {
        return JsonMessages.localize("objbuilder.array.builder.null", new Object[0]);
    }

    static String ARRBUILDER_VALUE_NULL() {
        return JsonMessages.localize("arrbuilder.value.null", new Object[0]);
    }

    static String ARRBUILDER_OBJECT_BUILDER_NULL() {
        return JsonMessages.localize("arrbuilder.object.builder.null", new Object[0]);
    }

    static String ARRBUILDER_ARRAY_BUILDER_NULL() {
        return JsonMessages.localize("arrbuilder.array.builder.null", new Object[0]);
    }

    private static String localize(String key, Object ... args2) {
        try {
            String msg = BUNDLE.getString(key);
            return MessageFormat.format(msg, args2);
        }
        catch (Exception e) {
            return JsonMessages.getDefaultMessage(key, args2);
        }
    }

    private static String getDefaultMessage(String key, Object ... args2) {
        StringBuilder sb = new StringBuilder();
        sb.append("[failed to localize] ");
        sb.append(key);
        if (args2 != null) {
            sb.append('(');
            for (int i = 0; i < args2.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(args2[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

